// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewLocalHostCreateParams creates a new LocalHostCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLocalHostCreateParams() *LocalHostCreateParams {
	return &LocalHostCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLocalHostCreateParamsWithTimeout creates a new LocalHostCreateParams object
// with the ability to set a timeout on a request.
func NewLocalHostCreateParamsWithTimeout(timeout time.Duration) *LocalHostCreateParams {
	return &LocalHostCreateParams{
		timeout: timeout,
	}
}

// NewLocalHostCreateParamsWithContext creates a new LocalHostCreateParams object
// with the ability to set a context for a request.
func NewLocalHostCreateParamsWithContext(ctx context.Context) *LocalHostCreateParams {
	return &LocalHostCreateParams{
		Context: ctx,
	}
}

// NewLocalHostCreateParamsWithHTTPClient creates a new LocalHostCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewLocalHostCreateParamsWithHTTPClient(client *http.Client) *LocalHostCreateParams {
	return &LocalHostCreateParams{
		HTTPClient: client,
	}
}

/*
LocalHostCreateParams contains all the parameters to send to the API endpoint

	for the local host create operation.

	Typically these are written to a http.Request.
*/
type LocalHostCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.LocalHost

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the local host create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostCreateParams) WithDefaults() *LocalHostCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the local host create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := LocalHostCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the local host create params
func (o *LocalHostCreateParams) WithTimeout(timeout time.Duration) *LocalHostCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the local host create params
func (o *LocalHostCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the local host create params
func (o *LocalHostCreateParams) WithContext(ctx context.Context) *LocalHostCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the local host create params
func (o *LocalHostCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the local host create params
func (o *LocalHostCreateParams) WithHTTPClient(client *http.Client) *LocalHostCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the local host create params
func (o *LocalHostCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the local host create params
func (o *LocalHostCreateParams) WithInfo(info *models.LocalHost) *LocalHostCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the local host create params
func (o *LocalHostCreateParams) SetInfo(info *models.LocalHost) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the local host create params
func (o *LocalHostCreateParams) WithReturnRecords(returnRecords *bool) *LocalHostCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the local host create params
func (o *LocalHostCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *LocalHostCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
