// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalHostDeleteCollectionReader is a Reader for the LocalHostDeleteCollection structure.
type LocalHostDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalHostDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalHostDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalHostDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalHostDeleteCollectionOK creates a LocalHostDeleteCollectionOK with default headers values
func NewLocalHostDeleteCollectionOK() *LocalHostDeleteCollectionOK {
	return &LocalHostDeleteCollectionOK{}
}

/*
LocalHostDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LocalHostDeleteCollectionOK struct {
}

// IsSuccess returns true when this local host delete collection o k response has a 2xx status code
func (o *LocalHostDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local host delete collection o k response has a 3xx status code
func (o *LocalHostDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local host delete collection o k response has a 4xx status code
func (o *LocalHostDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local host delete collection o k response has a 5xx status code
func (o *LocalHostDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local host delete collection o k response a status code equal to that given
func (o *LocalHostDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local host delete collection o k response
func (o *LocalHostDeleteCollectionOK) Code() int {
	return 200
}

func (o *LocalHostDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/local-hosts][%d] localHostDeleteCollectionOK", 200)
}

func (o *LocalHostDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/local-hosts][%d] localHostDeleteCollectionOK", 200)
}

func (o *LocalHostDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalHostDeleteCollectionDefault creates a LocalHostDeleteCollectionDefault with default headers values
func NewLocalHostDeleteCollectionDefault(code int) *LocalHostDeleteCollectionDefault {
	return &LocalHostDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LocalHostDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LocalHostDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local host delete collection default response has a 2xx status code
func (o *LocalHostDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local host delete collection default response has a 3xx status code
func (o *LocalHostDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local host delete collection default response has a 4xx status code
func (o *LocalHostDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local host delete collection default response has a 5xx status code
func (o *LocalHostDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local host delete collection default response a status code equal to that given
func (o *LocalHostDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local host delete collection default response
func (o *LocalHostDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LocalHostDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/local-hosts][%d] local_host_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalHostDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/local-hosts][%d] local_host_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalHostDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalHostDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LocalHostDeleteCollectionBody local host delete collection body
swagger:model LocalHostDeleteCollectionBody
*/
type LocalHostDeleteCollectionBody struct {

	// local host response inline records
	LocalHostResponseInlineRecords []*models.LocalHost `json:"records,omitempty"`
}

// Validate validates this local host delete collection body
func (o *LocalHostDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocalHostResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalHostDeleteCollectionBody) validateLocalHostResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalHostResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LocalHostResponseInlineRecords); i++ {
		if swag.IsZero(o.LocalHostResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LocalHostResponseInlineRecords[i] != nil {
			if err := o.LocalHostResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this local host delete collection body based on the context it is used
func (o *LocalHostDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocalHostResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalHostDeleteCollectionBody) contextValidateLocalHostResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LocalHostResponseInlineRecords); i++ {

		if o.LocalHostResponseInlineRecords[i] != nil {
			if err := o.LocalHostResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalHostDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalHostDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LocalHostDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
