// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewLocalHostDeleteParams creates a new LocalHostDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLocalHostDeleteParams() *LocalHostDeleteParams {
	return &LocalHostDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLocalHostDeleteParamsWithTimeout creates a new LocalHostDeleteParams object
// with the ability to set a timeout on a request.
func NewLocalHostDeleteParamsWithTimeout(timeout time.Duration) *LocalHostDeleteParams {
	return &LocalHostDeleteParams{
		timeout: timeout,
	}
}

// NewLocalHostDeleteParamsWithContext creates a new LocalHostDeleteParams object
// with the ability to set a context for a request.
func NewLocalHostDeleteParamsWithContext(ctx context.Context) *LocalHostDeleteParams {
	return &LocalHostDeleteParams{
		Context: ctx,
	}
}

// NewLocalHostDeleteParamsWithHTTPClient creates a new LocalHostDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewLocalHostDeleteParamsWithHTTPClient(client *http.Client) *LocalHostDeleteParams {
	return &LocalHostDeleteParams{
		HTTPClient: client,
	}
}

/*
LocalHostDeleteParams contains all the parameters to send to the API endpoint

	for the local host delete operation.

	Typically these are written to a http.Request.
*/
type LocalHostDeleteParams struct {

	/* Address.

	   The IP address.
	*/
	Address string

	/* OwnerUUID.

	   UUID of the owner to which this object belongs.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the local host delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostDeleteParams) WithDefaults() *LocalHostDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the local host delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the local host delete params
func (o *LocalHostDeleteParams) WithTimeout(timeout time.Duration) *LocalHostDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the local host delete params
func (o *LocalHostDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the local host delete params
func (o *LocalHostDeleteParams) WithContext(ctx context.Context) *LocalHostDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the local host delete params
func (o *LocalHostDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the local host delete params
func (o *LocalHostDeleteParams) WithHTTPClient(client *http.Client) *LocalHostDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the local host delete params
func (o *LocalHostDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the local host delete params
func (o *LocalHostDeleteParams) WithAddress(address string) *LocalHostDeleteParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the local host delete params
func (o *LocalHostDeleteParams) SetAddress(address string) {
	o.Address = address
}

// WithOwnerUUID adds the ownerUUID to the local host delete params
func (o *LocalHostDeleteParams) WithOwnerUUID(ownerUUID string) *LocalHostDeleteParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the local host delete params
func (o *LocalHostDeleteParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LocalHostDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param address
	if err := r.SetPathParam("address", o.Address); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
