// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLocalHostGetParams creates a new LocalHostGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLocalHostGetParams() *LocalHostGetParams {
	return &LocalHostGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLocalHostGetParamsWithTimeout creates a new LocalHostGetParams object
// with the ability to set a timeout on a request.
func NewLocalHostGetParamsWithTimeout(timeout time.Duration) *LocalHostGetParams {
	return &LocalHostGetParams{
		timeout: timeout,
	}
}

// NewLocalHostGetParamsWithContext creates a new LocalHostGetParams object
// with the ability to set a context for a request.
func NewLocalHostGetParamsWithContext(ctx context.Context) *LocalHostGetParams {
	return &LocalHostGetParams{
		Context: ctx,
	}
}

// NewLocalHostGetParamsWithHTTPClient creates a new LocalHostGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLocalHostGetParamsWithHTTPClient(client *http.Client) *LocalHostGetParams {
	return &LocalHostGetParams{
		HTTPClient: client,
	}
}

/*
LocalHostGetParams contains all the parameters to send to the API endpoint

	for the local host get operation.

	Typically these are written to a http.Request.
*/
type LocalHostGetParams struct {

	/* Address.

	   The IP address.
	*/
	Address string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   UUID of the owner to which this object belongs.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the local host get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostGetParams) WithDefaults() *LocalHostGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the local host get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalHostGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the local host get params
func (o *LocalHostGetParams) WithTimeout(timeout time.Duration) *LocalHostGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the local host get params
func (o *LocalHostGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the local host get params
func (o *LocalHostGetParams) WithContext(ctx context.Context) *LocalHostGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the local host get params
func (o *LocalHostGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the local host get params
func (o *LocalHostGetParams) WithHTTPClient(client *http.Client) *LocalHostGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the local host get params
func (o *LocalHostGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the local host get params
func (o *LocalHostGetParams) WithAddress(address string) *LocalHostGetParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the local host get params
func (o *LocalHostGetParams) SetAddress(address string) {
	o.Address = address
}

// WithFields adds the fields to the local host get params
func (o *LocalHostGetParams) WithFields(fields []string) *LocalHostGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the local host get params
func (o *LocalHostGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the local host get params
func (o *LocalHostGetParams) WithOwnerUUID(ownerUUID string) *LocalHostGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the local host get params
func (o *LocalHostGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LocalHostGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param address
	if err := r.SetPathParam("address", o.Address); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLocalHostGet binds the parameter fields
func (o *LocalHostGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
