// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalHostGetReader is a Reader for the LocalHostGet structure.
type LocalHostGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalHostGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalHostGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalHostGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalHostGetOK creates a LocalHostGetOK with default headers values
func NewLocalHostGetOK() *LocalHostGetOK {
	return &LocalHostGetOK{}
}

/*
LocalHostGetOK describes a response with status code 200, with default header values.

OK
*/
type LocalHostGetOK struct {
	Payload *models.LocalHost
}

// IsSuccess returns true when this local host get o k response has a 2xx status code
func (o *LocalHostGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local host get o k response has a 3xx status code
func (o *LocalHostGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local host get o k response has a 4xx status code
func (o *LocalHostGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local host get o k response has a 5xx status code
func (o *LocalHostGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local host get o k response a status code equal to that given
func (o *LocalHostGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local host get o k response
func (o *LocalHostGetOK) Code() int {
	return 200
}

func (o *LocalHostGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts/{owner.uuid}/{address}][%d] localHostGetOK %s", 200, payload)
}

func (o *LocalHostGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts/{owner.uuid}/{address}][%d] localHostGetOK %s", 200, payload)
}

func (o *LocalHostGetOK) GetPayload() *models.LocalHost {
	return o.Payload
}

func (o *LocalHostGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LocalHost)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLocalHostGetDefault creates a LocalHostGetDefault with default headers values
func NewLocalHostGetDefault(code int) *LocalHostGetDefault {
	return &LocalHostGetDefault{
		_statusCode: code,
	}
}

/*
LocalHostGetDefault describes a response with status code -1, with default header values.

Error
*/
type LocalHostGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local host get default response has a 2xx status code
func (o *LocalHostGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local host get default response has a 3xx status code
func (o *LocalHostGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local host get default response has a 4xx status code
func (o *LocalHostGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local host get default response has a 5xx status code
func (o *LocalHostGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local host get default response a status code equal to that given
func (o *LocalHostGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local host get default response
func (o *LocalHostGetDefault) Code() int {
	return o._statusCode
}

func (o *LocalHostGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts/{owner.uuid}/{address}][%d] local_host_get default %s", o._statusCode, payload)
}

func (o *LocalHostGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/local-hosts/{owner.uuid}/{address}][%d] local_host_get default %s", o._statusCode, payload)
}

func (o *LocalHostGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalHostGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
