// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalHostModifyReader is a Reader for the LocalHostModify structure.
type LocalHostModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalHostModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalHostModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalHostModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalHostModifyOK creates a LocalHostModifyOK with default headers values
func NewLocalHostModifyOK() *LocalHostModifyOK {
	return &LocalHostModifyOK{}
}

/*
LocalHostModifyOK describes a response with status code 200, with default header values.

OK
*/
type LocalHostModifyOK struct {
}

// IsSuccess returns true when this local host modify o k response has a 2xx status code
func (o *LocalHostModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local host modify o k response has a 3xx status code
func (o *LocalHostModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local host modify o k response has a 4xx status code
func (o *LocalHostModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local host modify o k response has a 5xx status code
func (o *LocalHostModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local host modify o k response a status code equal to that given
func (o *LocalHostModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local host modify o k response
func (o *LocalHostModifyOK) Code() int {
	return 200
}

func (o *LocalHostModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/local-hosts/{owner.uuid}/{address}][%d] localHostModifyOK", 200)
}

func (o *LocalHostModifyOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/local-hosts/{owner.uuid}/{address}][%d] localHostModifyOK", 200)
}

func (o *LocalHostModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalHostModifyDefault creates a LocalHostModifyDefault with default headers values
func NewLocalHostModifyDefault(code int) *LocalHostModifyDefault {
	return &LocalHostModifyDefault{
		_statusCode: code,
	}
}

/*
	LocalHostModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LocalHostModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local host modify default response has a 2xx status code
func (o *LocalHostModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local host modify default response has a 3xx status code
func (o *LocalHostModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local host modify default response has a 4xx status code
func (o *LocalHostModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local host modify default response has a 5xx status code
func (o *LocalHostModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local host modify default response a status code equal to that given
func (o *LocalHostModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local host modify default response
func (o *LocalHostModifyDefault) Code() int {
	return o._statusCode
}

func (o *LocalHostModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/local-hosts/{owner.uuid}/{address}][%d] local_host_modify default %s", o._statusCode, payload)
}

func (o *LocalHostModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/local-hosts/{owner.uuid}/{address}][%d] local_host_modify default %s", o._statusCode, payload)
}

func (o *LocalHostModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalHostModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
