// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NameMappingCollectionGetReader is a Reader for the NameMappingCollectionGet structure.
type NameMappingCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NameMappingCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNameMappingCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNameMappingCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNameMappingCollectionGetOK creates a NameMappingCollectionGetOK with default headers values
func NewNameMappingCollectionGetOK() *NameMappingCollectionGetOK {
	return &NameMappingCollectionGetOK{}
}

/*
NameMappingCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type NameMappingCollectionGetOK struct {
	Payload *models.NameMappingResponse
}

// IsSuccess returns true when this name mapping collection get o k response has a 2xx status code
func (o *NameMappingCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this name mapping collection get o k response has a 3xx status code
func (o *NameMappingCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this name mapping collection get o k response has a 4xx status code
func (o *NameMappingCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this name mapping collection get o k response has a 5xx status code
func (o *NameMappingCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this name mapping collection get o k response a status code equal to that given
func (o *NameMappingCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the name mapping collection get o k response
func (o *NameMappingCollectionGetOK) Code() int {
	return 200
}

func (o *NameMappingCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/name-mappings][%d] nameMappingCollectionGetOK %s", 200, payload)
}

func (o *NameMappingCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/name-mappings][%d] nameMappingCollectionGetOK %s", 200, payload)
}

func (o *NameMappingCollectionGetOK) GetPayload() *models.NameMappingResponse {
	return o.Payload
}

func (o *NameMappingCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NameMappingResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNameMappingCollectionGetDefault creates a NameMappingCollectionGetDefault with default headers values
func NewNameMappingCollectionGetDefault(code int) *NameMappingCollectionGetDefault {
	return &NameMappingCollectionGetDefault{
		_statusCode: code,
	}
}

/*
NameMappingCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type NameMappingCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this name mapping collection get default response has a 2xx status code
func (o *NameMappingCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this name mapping collection get default response has a 3xx status code
func (o *NameMappingCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this name mapping collection get default response has a 4xx status code
func (o *NameMappingCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this name mapping collection get default response has a 5xx status code
func (o *NameMappingCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this name mapping collection get default response a status code equal to that given
func (o *NameMappingCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the name mapping collection get default response
func (o *NameMappingCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *NameMappingCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/name-mappings][%d] name_mapping_collection_get default %s", o._statusCode, payload)
}

func (o *NameMappingCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/name-mappings][%d] name_mapping_collection_get default %s", o._statusCode, payload)
}

func (o *NameMappingCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NameMappingCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
