// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NameMappingCreateReader is a Reader for the NameMappingCreate structure.
type NameMappingCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NameMappingCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewNameMappingCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNameMappingCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNameMappingCreateCreated creates a NameMappingCreateCreated with default headers values
func NewNameMappingCreateCreated() *NameMappingCreateCreated {
	return &NameMappingCreateCreated{}
}

/*
NameMappingCreateCreated describes a response with status code 201, with default header values.

Created
*/
type NameMappingCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.NameMappingResponse
}

// IsSuccess returns true when this name mapping create created response has a 2xx status code
func (o *NameMappingCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this name mapping create created response has a 3xx status code
func (o *NameMappingCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this name mapping create created response has a 4xx status code
func (o *NameMappingCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this name mapping create created response has a 5xx status code
func (o *NameMappingCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this name mapping create created response a status code equal to that given
func (o *NameMappingCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the name mapping create created response
func (o *NameMappingCreateCreated) Code() int {
	return 201
}

func (o *NameMappingCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/name-mappings][%d] nameMappingCreateCreated %s", 201, payload)
}

func (o *NameMappingCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/name-mappings][%d] nameMappingCreateCreated %s", 201, payload)
}

func (o *NameMappingCreateCreated) GetPayload() *models.NameMappingResponse {
	return o.Payload
}

func (o *NameMappingCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.NameMappingResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNameMappingCreateDefault creates a NameMappingCreateDefault with default headers values
func NewNameMappingCreateDefault(code int) *NameMappingCreateDefault {
	return &NameMappingCreateDefault{
		_statusCode: code,
	}
}

/*
	NameMappingCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65798185   | Failed to resolve the specified hostname   |
| 65798173   | The name mapping pattern already exists with a more generic IP qualifier   |
| 65798149   | Invalid index for the name mapping entry   |
| 2621706    | The specified svm.uuid and svm.name refer to different SVMs   |
*/
type NameMappingCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this name mapping create default response has a 2xx status code
func (o *NameMappingCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this name mapping create default response has a 3xx status code
func (o *NameMappingCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this name mapping create default response has a 4xx status code
func (o *NameMappingCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this name mapping create default response has a 5xx status code
func (o *NameMappingCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this name mapping create default response a status code equal to that given
func (o *NameMappingCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the name mapping create default response
func (o *NameMappingCreateDefault) Code() int {
	return o._statusCode
}

func (o *NameMappingCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/name-mappings][%d] name_mapping_create default %s", o._statusCode, payload)
}

func (o *NameMappingCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/name-mappings][%d] name_mapping_create default %s", o._statusCode, payload)
}

func (o *NameMappingCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NameMappingCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
