// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNameMappingDeleteCollectionParams creates a new NameMappingDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNameMappingDeleteCollectionParams() *NameMappingDeleteCollectionParams {
	return &NameMappingDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNameMappingDeleteCollectionParamsWithTimeout creates a new NameMappingDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewNameMappingDeleteCollectionParamsWithTimeout(timeout time.Duration) *NameMappingDeleteCollectionParams {
	return &NameMappingDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewNameMappingDeleteCollectionParamsWithContext creates a new NameMappingDeleteCollectionParams object
// with the ability to set a context for a request.
func NewNameMappingDeleteCollectionParamsWithContext(ctx context.Context) *NameMappingDeleteCollectionParams {
	return &NameMappingDeleteCollectionParams{
		Context: ctx,
	}
}

// NewNameMappingDeleteCollectionParamsWithHTTPClient creates a new NameMappingDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNameMappingDeleteCollectionParamsWithHTTPClient(client *http.Client) *NameMappingDeleteCollectionParams {
	return &NameMappingDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
NameMappingDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the name mapping delete collection operation.

	Typically these are written to a http.Request.
*/
type NameMappingDeleteCollectionParams struct {

	/* ClientMatch.

	   Filter by client_match
	*/
	ClientMatch *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Direction.

	   Filter by direction
	*/
	Direction *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Info.

	   Info specification
	*/
	Info NameMappingDeleteCollectionBody

	/* Pattern.

	   Filter by pattern
	*/
	Pattern *string

	/* Replacement.

	   Filter by replacement
	*/
	Replacement *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the name mapping delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NameMappingDeleteCollectionParams) WithDefaults() *NameMappingDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the name mapping delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NameMappingDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NameMappingDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithTimeout(timeout time.Duration) *NameMappingDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithContext(ctx context.Context) *NameMappingDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithHTTPClient(client *http.Client) *NameMappingDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClientMatch adds the clientMatch to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithClientMatch(clientMatch *string) *NameMappingDeleteCollectionParams {
	o.SetClientMatch(clientMatch)
	return o
}

// SetClientMatch adds the clientMatch to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetClientMatch(clientMatch *string) {
	o.ClientMatch = clientMatch
}

// WithContinueOnFailure adds the continueOnFailure to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NameMappingDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDirection adds the direction to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithDirection(direction *string) *NameMappingDeleteCollectionParams {
	o.SetDirection(direction)
	return o
}

// SetDirection adds the direction to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetDirection(direction *string) {
	o.Direction = direction
}

// WithIndex adds the index to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithIndex(index *int64) *NameMappingDeleteCollectionParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInfo adds the info to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithInfo(info NameMappingDeleteCollectionBody) *NameMappingDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetInfo(info NameMappingDeleteCollectionBody) {
	o.Info = info
}

// WithPattern adds the pattern to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithPattern(pattern *string) *NameMappingDeleteCollectionParams {
	o.SetPattern(pattern)
	return o
}

// SetPattern adds the pattern to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetPattern(pattern *string) {
	o.Pattern = pattern
}

// WithReplacement adds the replacement to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithReplacement(replacement *string) *NameMappingDeleteCollectionParams {
	o.SetReplacement(replacement)
	return o
}

// SetReplacement adds the replacement to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetReplacement(replacement *string) {
	o.Replacement = replacement
}

// WithReturnRecords adds the returnRecords to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *NameMappingDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *NameMappingDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *NameMappingDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithSvmName(svmName *string) *NameMappingDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) WithSvmUUID(svmUUID *string) *NameMappingDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the name mapping delete collection params
func (o *NameMappingDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NameMappingDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClientMatch != nil {

		// query param client_match
		var qrClientMatch string

		if o.ClientMatch != nil {
			qrClientMatch = *o.ClientMatch
		}
		qClientMatch := qrClientMatch
		if qClientMatch != "" {

			if err := r.SetQueryParam("client_match", qClientMatch); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Direction != nil {

		// query param direction
		var qrDirection string

		if o.Direction != nil {
			qrDirection = *o.Direction
		}
		qDirection := qrDirection
		if qDirection != "" {

			if err := r.SetQueryParam("direction", qDirection); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Pattern != nil {

		// query param pattern
		var qrPattern string

		if o.Pattern != nil {
			qrPattern = *o.Pattern
		}
		qPattern := qrPattern
		if qPattern != "" {

			if err := r.SetQueryParam("pattern", qPattern); err != nil {
				return err
			}
		}
	}

	if o.Replacement != nil {

		// query param replacement
		var qrReplacement string

		if o.Replacement != nil {
			qrReplacement = *o.Replacement
		}
		qReplacement := qrReplacement
		if qReplacement != "" {

			if err := r.SetQueryParam("replacement", qReplacement); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
