// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NameMappingDeleteCollectionReader is a Reader for the NameMappingDeleteCollection structure.
type NameMappingDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NameMappingDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNameMappingDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNameMappingDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNameMappingDeleteCollectionOK creates a NameMappingDeleteCollectionOK with default headers values
func NewNameMappingDeleteCollectionOK() *NameMappingDeleteCollectionOK {
	return &NameMappingDeleteCollectionOK{}
}

/*
NameMappingDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NameMappingDeleteCollectionOK struct {
}

// IsSuccess returns true when this name mapping delete collection o k response has a 2xx status code
func (o *NameMappingDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this name mapping delete collection o k response has a 3xx status code
func (o *NameMappingDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this name mapping delete collection o k response has a 4xx status code
func (o *NameMappingDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this name mapping delete collection o k response has a 5xx status code
func (o *NameMappingDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this name mapping delete collection o k response a status code equal to that given
func (o *NameMappingDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the name mapping delete collection o k response
func (o *NameMappingDeleteCollectionOK) Code() int {
	return 200
}

func (o *NameMappingDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/name-mappings][%d] nameMappingDeleteCollectionOK", 200)
}

func (o *NameMappingDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/name-mappings][%d] nameMappingDeleteCollectionOK", 200)
}

func (o *NameMappingDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNameMappingDeleteCollectionDefault creates a NameMappingDeleteCollectionDefault with default headers values
func NewNameMappingDeleteCollectionDefault(code int) *NameMappingDeleteCollectionDefault {
	return &NameMappingDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
NameMappingDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type NameMappingDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this name mapping delete collection default response has a 2xx status code
func (o *NameMappingDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this name mapping delete collection default response has a 3xx status code
func (o *NameMappingDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this name mapping delete collection default response has a 4xx status code
func (o *NameMappingDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this name mapping delete collection default response has a 5xx status code
func (o *NameMappingDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this name mapping delete collection default response a status code equal to that given
func (o *NameMappingDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the name mapping delete collection default response
func (o *NameMappingDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NameMappingDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/name-mappings][%d] name_mapping_delete_collection default %s", o._statusCode, payload)
}

func (o *NameMappingDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/name-mappings][%d] name_mapping_delete_collection default %s", o._statusCode, payload)
}

func (o *NameMappingDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NameMappingDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NameMappingDeleteCollectionBody name mapping delete collection body
swagger:model NameMappingDeleteCollectionBody
*/
type NameMappingDeleteCollectionBody struct {

	// name mapping response inline records
	NameMappingResponseInlineRecords []*models.NameMapping `json:"records,omitempty"`
}

// Validate validates this name mapping delete collection body
func (o *NameMappingDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNameMappingResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NameMappingDeleteCollectionBody) validateNameMappingResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NameMappingResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NameMappingResponseInlineRecords); i++ {
		if swag.IsZero(o.NameMappingResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NameMappingResponseInlineRecords[i] != nil {
			if err := o.NameMappingResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this name mapping delete collection body based on the context it is used
func (o *NameMappingDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNameMappingResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NameMappingDeleteCollectionBody) contextValidateNameMappingResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NameMappingResponseInlineRecords); i++ {

		if o.NameMappingResponseInlineRecords[i] != nil {
			if err := o.NameMappingResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NameMappingDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NameMappingDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NameMappingDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
