// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNameMappingDeleteParams creates a new NameMappingDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNameMappingDeleteParams() *NameMappingDeleteParams {
	return &NameMappingDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNameMappingDeleteParamsWithTimeout creates a new NameMappingDeleteParams object
// with the ability to set a timeout on a request.
func NewNameMappingDeleteParamsWithTimeout(timeout time.Duration) *NameMappingDeleteParams {
	return &NameMappingDeleteParams{
		timeout: timeout,
	}
}

// NewNameMappingDeleteParamsWithContext creates a new NameMappingDeleteParams object
// with the ability to set a context for a request.
func NewNameMappingDeleteParamsWithContext(ctx context.Context) *NameMappingDeleteParams {
	return &NameMappingDeleteParams{
		Context: ctx,
	}
}

// NewNameMappingDeleteParamsWithHTTPClient creates a new NameMappingDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewNameMappingDeleteParamsWithHTTPClient(client *http.Client) *NameMappingDeleteParams {
	return &NameMappingDeleteParams{
		HTTPClient: client,
	}
}

/*
NameMappingDeleteParams contains all the parameters to send to the API endpoint

	for the name mapping delete operation.

	Typically these are written to a http.Request.
*/
type NameMappingDeleteParams struct {

	/* Direction.

	   Direction
	*/
	Direction string

	/* Index.

	   Position of the entry in the list
	*/
	Index int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the name mapping delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NameMappingDeleteParams) WithDefaults() *NameMappingDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the name mapping delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NameMappingDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the name mapping delete params
func (o *NameMappingDeleteParams) WithTimeout(timeout time.Duration) *NameMappingDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the name mapping delete params
func (o *NameMappingDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the name mapping delete params
func (o *NameMappingDeleteParams) WithContext(ctx context.Context) *NameMappingDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the name mapping delete params
func (o *NameMappingDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the name mapping delete params
func (o *NameMappingDeleteParams) WithHTTPClient(client *http.Client) *NameMappingDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the name mapping delete params
func (o *NameMappingDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDirection adds the direction to the name mapping delete params
func (o *NameMappingDeleteParams) WithDirection(direction string) *NameMappingDeleteParams {
	o.SetDirection(direction)
	return o
}

// SetDirection adds the direction to the name mapping delete params
func (o *NameMappingDeleteParams) SetDirection(direction string) {
	o.Direction = direction
}

// WithIndex adds the index to the name mapping delete params
func (o *NameMappingDeleteParams) WithIndex(index int64) *NameMappingDeleteParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the name mapping delete params
func (o *NameMappingDeleteParams) SetIndex(index int64) {
	o.Index = index
}

// WithSvmUUID adds the svmUUID to the name mapping delete params
func (o *NameMappingDeleteParams) WithSvmUUID(svmUUID string) *NameMappingDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the name mapping delete params
func (o *NameMappingDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NameMappingDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param direction
	if err := r.SetPathParam("direction", o.Direction); err != nil {
		return err
	}

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
