// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NameMappingModifyReader is a Reader for the NameMappingModify structure.
type NameMappingModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NameMappingModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNameMappingModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNameMappingModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNameMappingModifyOK creates a NameMappingModifyOK with default headers values
func NewNameMappingModifyOK() *NameMappingModifyOK {
	return &NameMappingModifyOK{}
}

/*
NameMappingModifyOK describes a response with status code 200, with default header values.

OK
*/
type NameMappingModifyOK struct {
}

// IsSuccess returns true when this name mapping modify o k response has a 2xx status code
func (o *NameMappingModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this name mapping modify o k response has a 3xx status code
func (o *NameMappingModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this name mapping modify o k response has a 4xx status code
func (o *NameMappingModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this name mapping modify o k response has a 5xx status code
func (o *NameMappingModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this name mapping modify o k response a status code equal to that given
func (o *NameMappingModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the name mapping modify o k response
func (o *NameMappingModifyOK) Code() int {
	return 200
}

func (o *NameMappingModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/name-mappings/{svm.uuid}/{direction}/{index}][%d] nameMappingModifyOK", 200)
}

func (o *NameMappingModifyOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/name-mappings/{svm.uuid}/{direction}/{index}][%d] nameMappingModifyOK", 200)
}

func (o *NameMappingModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNameMappingModifyDefault creates a NameMappingModifyDefault with default headers values
func NewNameMappingModifyDefault(code int) *NameMappingModifyDefault {
	return &NameMappingModifyDefault{
		_statusCode: code,
	}
}

/*
	NameMappingModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65798185   | Failed to resolve the specified hostname |
| 65798179   | Cannot swap entries because one or both entries have host name or address configured.|
|            | Delete and re-create the new entry at the specified position.|
*/
type NameMappingModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this name mapping modify default response has a 2xx status code
func (o *NameMappingModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this name mapping modify default response has a 3xx status code
func (o *NameMappingModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this name mapping modify default response has a 4xx status code
func (o *NameMappingModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this name mapping modify default response has a 5xx status code
func (o *NameMappingModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this name mapping modify default response a status code equal to that given
func (o *NameMappingModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the name mapping modify default response
func (o *NameMappingModifyDefault) Code() int {
	return o._statusCode
}

func (o *NameMappingModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/name-mappings/{svm.uuid}/{direction}/{index}][%d] name_mapping_modify default %s", o._statusCode, payload)
}

func (o *NameMappingModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/name-mappings/{svm.uuid}/{direction}/{index}][%d] name_mapping_modify default %s", o._statusCode, payload)
}

func (o *NameMappingModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NameMappingModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
