// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new name services API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for name services API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DNSCollectionGet(params *DNSCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSCollectionGetOK, error)

	DNSCreate(params *DNSCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSCreateCreated, error)

	DNSDelete(params *DNSDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSDeleteOK, error)

	DNSDeleteCollection(params *DNSDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSDeleteCollectionOK, error)

	DNSGet(params *DNSGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSGetOK, error)

	DNSModify(params *DNSModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSModifyOK, error)

	DNSModifyCollection(params *DNSModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSModifyCollectionOK, error)

	GlobalCacheSettingGet(params *GlobalCacheSettingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GlobalCacheSettingGetOK, error)

	GlobalCacheSettingModify(params *GlobalCacheSettingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GlobalCacheSettingModifyOK, error)

	GroupMembershipSettingsCollectionGet(params *GroupMembershipSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsCollectionGetOK, error)

	GroupMembershipSettingsGet(params *GroupMembershipSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsGetOK, error)

	GroupMembershipSettingsModify(params *GroupMembershipSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsModifyOK, error)

	GroupMembershipSettingsModifyCollection(params *GroupMembershipSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsModifyCollectionOK, error)

	HostRecordGet(params *HostRecordGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostRecordGetOK, error)

	HostsSettingsCollectionGet(params *HostsSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsCollectionGetOK, error)

	HostsSettingsGet(params *HostsSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsGetOK, error)

	HostsSettingsModify(params *HostsSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsModifyOK, error)

	HostsSettingsModifyCollection(params *HostsSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsModifyCollectionOK, error)

	LdapCollectionGet(params *LdapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapCollectionGetOK, error)

	LdapCreate(params *LdapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapCreateCreated, error)

	LdapDelete(params *LdapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapDeleteOK, error)

	LdapDeleteCollection(params *LdapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapDeleteCollectionOK, error)

	LdapGet(params *LdapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapGetOK, error)

	LdapModify(params *LdapModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapModifyOK, error)

	LdapModifyCollection(params *LdapModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapModifyCollectionOK, error)

	LdapSchemaCollectionGet(params *LdapSchemaCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaCollectionGetOK, error)

	LdapSchemaCreate(params *LdapSchemaCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaCreateCreated, error)

	LdapSchemaDelete(params *LdapSchemaDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaDeleteOK, error)

	LdapSchemaDeleteCollection(params *LdapSchemaDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaDeleteCollectionOK, error)

	LdapSchemaGet(params *LdapSchemaGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaGetOK, error)

	LdapSchemaModify(params *LdapSchemaModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaModifyOK, error)

	LdapSchemaModifyCollection(params *LdapSchemaModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaModifyCollectionOK, error)

	LocalHostCollectionGet(params *LocalHostCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostCollectionGetOK, error)

	LocalHostCreate(params *LocalHostCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostCreateCreated, error)

	LocalHostDelete(params *LocalHostDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostDeleteOK, error)

	LocalHostDeleteCollection(params *LocalHostDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostDeleteCollectionOK, error)

	LocalHostGet(params *LocalHostGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostGetOK, error)

	LocalHostModify(params *LocalHostModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostModifyOK, error)

	LocalHostModifyCollection(params *LocalHostModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostModifyCollectionOK, error)

	NameMappingCollectionGet(params *NameMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingCollectionGetOK, error)

	NameMappingCreate(params *NameMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingCreateCreated, error)

	NameMappingDelete(params *NameMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingDeleteOK, error)

	NameMappingDeleteCollection(params *NameMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingDeleteCollectionOK, error)

	NameMappingModify(params *NameMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingModifyOK, error)

	NameMappingModifyCollection(params *NameMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingModifyCollectionOK, error)

	NameMappingPositionGet(params *NameMappingPositionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingPositionGetOK, error)

	NetgroupFileDelete(params *NetgroupFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupFileDeleteOK, error)

	NetgroupFileGet(params *NetgroupFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupFileGetOK, error)

	NetgroupsSettingsCollectionGet(params *NetgroupsSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsCollectionGetOK, error)

	NetgroupsSettingsGet(params *NetgroupsSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsGetOK, error)

	NetgroupsSettingsModify(params *NetgroupsSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsModifyOK, error)

	NetgroupsSettingsModifyCollection(params *NetgroupsSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsModifyCollectionOK, error)

	NisCollectionGet(params *NisCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisCollectionGetOK, error)

	NisCreate(params *NisCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisCreateCreated, error)

	NisDelete(params *NisDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisDeleteOK, error)

	NisDeleteCollection(params *NisDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisDeleteCollectionOK, error)

	NisGet(params *NisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisGetOK, error)

	NisModify(params *NisModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisModifyOK, error)

	NisModifyCollection(params *NisModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisModifyCollectionOK, error)

	UnixGroupCollectionGet(params *UnixGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupCollectionGetOK, error)

	UnixGroupCreate(params *UnixGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupCreateCreated, error)

	UnixGroupDelete(params *UnixGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupDeleteOK, error)

	UnixGroupDeleteCollection(params *UnixGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupDeleteCollectionOK, error)

	UnixGroupGet(params *UnixGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupGetOK, error)

	UnixGroupModify(params *UnixGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupModifyOK, error)

	UnixGroupModifyCollection(params *UnixGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupModifyCollectionOK, error)

	UnixGroupSettingsCollectionGet(params *UnixGroupSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsCollectionGetOK, error)

	UnixGroupSettingsGet(params *UnixGroupSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsGetOK, error)

	UnixGroupSettingsModify(params *UnixGroupSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsModifyOK, error)

	UnixGroupSettingsModifyCollection(params *UnixGroupSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsModifyCollectionOK, error)

	UnixGroupUserDelete(params *UnixGroupUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUserDeleteOK, error)

	UnixGroupUserDeleteCollection(params *UnixGroupUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUserDeleteCollectionOK, error)

	UnixGroupUsersCollectionGet(params *UnixGroupUsersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersCollectionGetOK, error)

	UnixGroupUsersCreate(params *UnixGroupUsersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersCreateCreated, error)

	UnixGroupUsersGet(params *UnixGroupUsersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersGetOK, error)

	UnixUserCollectionGet(params *UnixUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserCollectionGetOK, error)

	UnixUserCreate(params *UnixUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserCreateCreated, error)

	UnixUserDelete(params *UnixUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserDeleteOK, error)

	UnixUserDeleteCollection(params *UnixUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserDeleteCollectionOK, error)

	UnixUserGet(params *UnixUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserGetOK, error)

	UnixUserModify(params *UnixUserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserModifyOK, error)

	UnixUserModifyCollection(params *UnixUserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserModifyCollectionOK, error)

	UnixUserSettingsCollectionGet(params *UnixUserSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsCollectionGetOK, error)

	UnixUserSettingsGet(params *UnixUserSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsGetOK, error)

	UnixUserSettingsModify(params *UnixUserSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsModifyOK, error)

	UnixUserSettingsModifyCollection(params *UnixUserSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsModifyCollectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	DNSCollectionGet Retrieves the DNS configurations of all SVMs.

Specify 'scope' as 'svm' to retrieve the DNS configuration of all the data SVMs.
Specify 'scope' as 'cluster' to retrieve the DNS configuration of the cluster.
### Advanced properties
* 'tld_query_enabled'
* 'source_address_match'
* 'packet_query_match'
* 'status' property retrieves the status of each name server of the DNS configuration for an SVM.
* 'service_ips' property is displayed only when both service.name and SVM are set.
### Related ONTAP commands
* `vserver services name-service dns show`
* `vserver services name-service dns check`
* `vserver services name-service dns dynamic-update show`
* `vserver services access-check dns srv-lookup`
### Learn more
* [`DOC /name-services/dns`](#docs-name-services-name-services_dns)
*/
func (a *Client) DNSCollectionGet(params *DNSCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/dns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DNSCreate Creates DNS domain and server configurations for an SVM.<br/>

### Important notes
- Each SVM can have only one DNS configuration.
- The domain name and the servers fields cannot be empty.
- IPv6 must be enabled if IPv6 family addresses are specified in the `servers` field.
- Configuring more than one DNS server is recommended to avoid a single point of failure.
- The DNS server specified using the `servers` field is validated during this operation.<br/>
</br> The validation fails in the following scenarios:<br/>
1. The server is not a DNS server.
2. The server does not exist.
3. The server is unreachable.<br/>
- The DNS server validation can be skipped by setting the property "skip_config_validation" to "true".
- Scope of the SVM can be specified using the "scope" parameter. "svm" scope refers to data SVMs and "cluster" scope refers to clusters.
#### The following parameters are optional:
- timeout
- attempts
- source_address_match
- packet_query_match
- tld_query_enabled
- skip_config_validation
- scope
- async
*/
func (a *Client) DNSCreate(params *DNSCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_create",
		Method:             "POST",
		PathPattern:        "/name-services/dns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DNSDelete Deletes DNS domain configuration of the specified SVM.

### Related ONTAP commands
* `vserver services name-service dns delete`
### Learn more
* [`DOC /name-services/dns`](#docs-name-services-name-services_dns)
*/
func (a *Client) DNSDelete(params *DNSDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/dns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DNSDeleteCollection dns delete collection API
*/
func (a *Client) DNSDeleteCollection(params *DNSDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/dns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DNSGet Retrieves DNS domain and server configuration of an SVM. By default, both DNS domains and servers are displayed.

### Advanced properties
* 'tld_query_enabled'
* 'source_address_match'
* 'packet_query_match'
* 'status' property retrieves the status of each name server of the DNS configuration for an SVM.
* 'service_ips' property is displayed only when both service.name and SVM are set.
### Related ONTAP commands
* `vserver services name-service dns show`
* `vserver services name-service dns check`
* `vserver services name-service dns dynamic-update show`
* `vserver services access-check dns srv-lookup`
### Learn more
* [`DOC /name-services/dns`](#docs-name-services-name-services_dns)
*/
func (a *Client) DNSGet(params *DNSGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_get",
		Method:             "GET",
		PathPattern:        "/name-services/dns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DNSModify Updates DNS domain and server configurations of an SVM.

### Important notes
- Both DNS domains and servers can be modified.
- The domains and servers fields cannot be empty.
- IPv6 must be enabled if IPv6 family addresses are specified for the `servers` field.
- The DNS server specified using the `servers` field is validated during this operation.<br/>
The validation fails in the following scenarios:<br/>
 1. The server is not a DNS server.
 2. The server does not exist.
 3. The server is unreachable.<br/>
    - The DNS server validation can be skipped by setting the property "skip_config_validation" to "true".
    - Dynamic DNS configuration can be modified.
    - If both DNS and Dynamic DNS parameters are modified, DNS parameters are updated first followed by Dynamic DNS parameters.
    If updating Dynamic DNS fails, then the updated DNS configuration is not reverted.

#### The following parameters are optional:
- timeout
- attempts
- source_address_match
- packet_query_match
- tld_query_enabled
- skip_config_validation
- dynamic_dns.enabled
- dynamic_dns.use_secure
- dynamic_dns.time_to_live
- async
### Related ONTAP commands
* `vserver services name-service dns modify`
* `vserver services name-service dns dynamic-update modify`
### Learn more
* [`DOC /name-services/dns`](#docs-name-services-name-services_dns)
*/
func (a *Client) DNSModify(params *DNSModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/dns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DNSModifyCollection dns modify collection API
*/
func (a *Client) DNSModifyCollection(params *DNSModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DNSModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDNSModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dns_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/dns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DNSModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DNSModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DNSModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GlobalCacheSettingGet Retrieves a global nameservice cache setting.

### Related ONTAP commands
* `vserver services name-service cache settings show`
### Learn more
* [`DOC /name-services/cache/setting`](#docs-name-services-name-services_cache_setting)
*/
func (a *Client) GlobalCacheSettingGet(params *GlobalCacheSettingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GlobalCacheSettingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGlobalCacheSettingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "global_cache_setting_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/setting",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GlobalCacheSettingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GlobalCacheSettingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GlobalCacheSettingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GlobalCacheSettingModify Updates a global nameservice cache setting.

### Important notes
  - Both the cache eviction time and remote fetch option can be modified.

### Related ONTAP commands
* `vserver services name-service cache settings modify`
### Learn more
* [`DOC /name-services/cache/setting`](#docs-name-services-name-services_cache_setting)
*/
func (a *Client) GlobalCacheSettingModify(params *GlobalCacheSettingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GlobalCacheSettingModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGlobalCacheSettingModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "global_cache_setting_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/setting",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GlobalCacheSettingModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GlobalCacheSettingModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GlobalCacheSettingModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupMembershipSettingsCollectionGet Retrieves group-membership cache settings.

### Related ONTAP commands
* `vserver services name-service cache group-membership settings show`
### Learn more
* [`DOC /name-services/cache/group-membership/settings`](#docs-name-services-name-services_cache_group-membership_settings)
*/
func (a *Client) GroupMembershipSettingsCollectionGet(params *GroupMembershipSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupMembershipSettingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_membership_settings_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/group-membership/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupMembershipSettingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupMembershipSettingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupMembershipSettingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupMembershipSettingsGet Retrieves a group-membership cache setting for a given SVM.

### Related ONTAP commands
* `vserver services name-service cache group-membership settings show`
### Learn more
* [`DOC /name-services/cache/group-membership/settings`](#docs-name-services-name-services_cache_group-membership_settings)
*/
func (a *Client) GroupMembershipSettingsGet(params *GroupMembershipSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupMembershipSettingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_membership_settings_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/group-membership/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupMembershipSettingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupMembershipSettingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupMembershipSettingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupMembershipSettingsModify Updates a group-membership cache setting.

### Important notes
  - svm.uuid field cannot be empty.
  - Returns success in case no values are provided for update.

### Related ONTAP commands
* `vserver services name-service cache group-membership settings modify`
### Learn more
* [`DOC /name-services/cache/group-membership/settings`](#docs-name-services-name-services_cache_group-membership_settings)
*/
func (a *Client) GroupMembershipSettingsModify(params *GroupMembershipSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupMembershipSettingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_membership_settings_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/group-membership/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupMembershipSettingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupMembershipSettingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupMembershipSettingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupMembershipSettingsModifyCollection group membership settings modify collection API
*/
func (a *Client) GroupMembershipSettingsModifyCollection(params *GroupMembershipSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupMembershipSettingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupMembershipSettingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_membership_settings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/group-membership/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupMembershipSettingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupMembershipSettingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupMembershipSettingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HostRecordGet Retrieves the IP address of the specified hostname and vice-versa.

### Related ONTAP commands
* `vserver services name-service getxxbyyy getnameinfo`
* `vserver services name-service getxxbyyy getaddrinfo`
*/
func (a *Client) HostRecordGet(params *HostRecordGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostRecordGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHostRecordGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "host_record_get",
		Method:             "GET",
		PathPattern:        "/name-services/host-record/{svm.uuid}/{host}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HostRecordGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HostRecordGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HostRecordGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HostsSettingsCollectionGet Retrieves host cache settings.

### Related ONTAP commands
* `vserver services name-service cache hosts settings show`
### Learn more
* [`DOC /name-services/cache/host/settings`](#docs-name-services-name-services_cache_host_settings)
*/
func (a *Client) HostsSettingsCollectionGet(params *HostsSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHostsSettingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "hosts_settings_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/host/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HostsSettingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HostsSettingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HostsSettingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HostsSettingsGet Retrieves a host cache setting for a given SVM.

### Related ONTAP commands
* `vserver services name-service cache hosts settings show`
### Learn more
* [`DOC /name-services/cache/host/settings`](#docs-name-services-name-services_cache_host_settings)
*/
func (a *Client) HostsSettingsGet(params *HostsSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHostsSettingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "hosts_settings_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/host/settings/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HostsSettingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HostsSettingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HostsSettingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HostsSettingsModify Updates a host cache setting.

### Important notes
  - UUID field cannot be empty.
  - Returns success in case no values are provided for update.

### Related ONTAP commands
* `vserver services name-service cache hosts settings modify`
### Learn more
* [`DOC /name-services/cache/host/settings`](#docs-name-services-name-services_cache_host_settings)
*/
func (a *Client) HostsSettingsModify(params *HostsSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHostsSettingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "hosts_settings_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/host/settings/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HostsSettingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HostsSettingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HostsSettingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
HostsSettingsModifyCollection hosts settings modify collection API
*/
func (a *Client) HostsSettingsModifyCollection(params *HostsSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HostsSettingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHostsSettingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "hosts_settings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/host/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HostsSettingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HostsSettingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HostsSettingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapCollectionGet Retrieves the LDAP configurations for all SVMs.

### Related ONTAP commands
  - `ldap show`
  - `ldap check -vserver vs0`
  - `ldap check-ipv6 -vserver vs0`

### Important notes
  - The status.code, status.dn_message, status.message, and status.state fields have the same status fields that are returned using the "ldap check" CLI command.
  - Refer to the ipv4 or ipv6 objects available in the status field to get specific information about the code, dn_messages, or message and state information for ipv4 or ipv6.
*/
func (a *Client) LdapCollectionGet(params *LdapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapCreate Creates an LDAP configuration for an SVM.

### Important notes
* Each SVM can have one LDAP configuration.
* The LDAP servers and Active Directory domain are mutually exclusive fields. These fields cannot be empty. At any point in time, either the LDAP servers or Active Directory domain must be populated.
* LDAP configuration with Active Directory domain cannot be created on an admin SVM.
* IPv6 must be enabled if IPv6 family addresses are specified.</br>
#### The following parameters are optional:
- preferred AD servers
- schema
- port
- ldaps_enabled
- min_bind_level
- bind_password
- base_scope
- use_start_tls
- session_security
- referral_enabled
- bind_as_cifs_server
- query_timeout
- user_dn
- user_scope
- group_dn
- group_scope
- netgroup_dn
- netgroup_scope
- netgroup_byhost_dn
- netgroup_byhost_scope
- is_netgroup_byhost_enabled
- group_membership_filter
- skip_config_validation
- try_channel_binding
- restrict_discovery_to_site</br>
Configuring more than one LDAP server is recommended to avoid a single point of failure.
Both FQDNs and IP addresses are supported for the "servers" field.
The Active Directory domain or LDAP servers are validated as part of this operation.</br>
LDAP validation fails in the following scenarios:<br/>
1. The server does not have LDAP installed.
2. The server or Active Directory domain is invalid.
3. The server or Active Directory domain is unreachable.<br/>
*/
func (a *Client) LdapCreate(params *LdapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_create",
		Method:             "POST",
		PathPattern:        "/name-services/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LdapDelete Deletes the LDAP configuration of the specified SVM. LDAP can be removed as a source from the ns-switch if LDAP is not used as a source for lookups.
*/
func (a *Client) LdapDelete(params *LdapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/ldap/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LdapDeleteCollection ldap delete collection API
*/
func (a *Client) LdapDeleteCollection(params *LdapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapGet Retrieves LDAP configuration for an SVM. All parameters for the LDAP configuration are displayed by default.

### Related ONTAP commands
  - `ldap show`
  - `ldap check -vserver vs0`
  - `ldap check-ipv6 -vserver vs0`

### Important notes
  - The status.code, status.dn_message, status.message, and status.state fields have the same status fields that are returned using the "ldap check" CLI command.
  - Refer to the ipv4 or ipv6 objects available in the status field to get specific information about the code, dn_messages, or message and state information for ipv4 or ipv6.
*/
func (a *Client) LdapGet(params *LdapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_get",
		Method:             "GET",
		PathPattern:        "/name-services/ldap/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapModify Updates an LDAP configuration of an SVM.

### Important notes
* Both mandatory and optional parameters of the LDAP configuration can be updated.
* The LDAP servers and Active Directory domain are mutually exclusive fields. These fields cannot be empty. At any point in time, either the LDAP servers or Active Directory domain must be populated.
* IPv6 must be enabled if IPv6 family addresses are specified.<br/>
</br>Configuring more than one LDAP server is recommended to avoid a single point of failure.
Both FQDNs and IP addresses are supported for the "servers" field.
The Active Directory domain or LDAP servers are validated as part of this operation.<br/>
LDAP validation fails in the following scenarios:<br/>
1. The server does not have LDAP installed.
2. The server or Active Directory domain is invalid.
3. The server or Active Directory domain is unreachable<br/>
*/
func (a *Client) LdapModify(params *LdapModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/ldap/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LdapModifyCollection ldap modify collection API
*/
func (a *Client) LdapModifyCollection(params *LdapModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapSchemaCollectionGet Retrieves all the LDAP schemas.

### Related ONTAP commands
* `vserver services name-service ldap client schema show`
*/
func (a *Client) LdapSchemaCollectionGet(params *LdapSchemaCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/ldap-schemas",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapSchemaCreate Creates an LDAP schema.

### Important notes
* To create a new schema, first create a copy of the default schemas provided by ONTAP and then modify the copy accordingly.
* If no value is specified for the owner.uuid or owner.name fields, the cserver UUID and name are used by default.
### Related ONTAP commands
* `vserver services name-service ldap client schema copy`
*/
func (a *Client) LdapSchemaCreate(params *LdapSchemaCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_create",
		Method:             "POST",
		PathPattern:        "/name-services/ldap-schemas",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapSchemaDelete Deletes an existing schema.

### Related ONTAP commands
* `vserver services name-service ldap client schema delete`
*/
func (a *Client) LdapSchemaDelete(params *LdapSchemaDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/ldap-schemas/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LdapSchemaDeleteCollection ldap schema delete collection API
*/
func (a *Client) LdapSchemaDeleteCollection(params *LdapSchemaDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/ldap-schemas",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapSchemaGet Retrieves LDAP schema details for a given owner and schema.

### Related ONTAP commands
* `vserver services name-service ldap client schema show`
*/
func (a *Client) LdapSchemaGet(params *LdapSchemaGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_get",
		Method:             "GET",
		PathPattern:        "/name-services/ldap-schemas/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LdapSchemaModify Updates LDAP schema details for a given owner and schema.

### Important notes
* The default LDAP schemas provided by ONTAP cannot be modified.
* LDAP schemas can only be modified by the owner of the schema.
### Related ONTAP commands
* `vserver services name-service ldap client schema modify`
*/
func (a *Client) LdapSchemaModify(params *LdapSchemaModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/ldap-schemas/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LdapSchemaModifyCollection ldap schema modify collection API
*/
func (a *Client) LdapSchemaModifyCollection(params *LdapSchemaModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LdapSchemaModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLdapSchemaModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ldap_schema_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/ldap-schemas",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LdapSchemaModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LdapSchemaModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LdapSchemaModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalHostCollectionGet Retrieves all IP to hostname mappings for all SVMs of the cluster.

### Related ONTAP commands
* `vserver services name-service dns hosts show`
### Learn more
* [`DOC /name-services/local-hosts`](#docs-name-services-name-services_local-hosts)
*/
func (a *Client) LocalHostCollectionGet(params *LocalHostCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/local-hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalHostCreate Creates a new cluster-scoped or SVM-scoped IP to hostname mapping. For SVM-scoped mappings, include either the SVM name as owner.name or the SVM UUID as owner.uuid in the request body, along with other necessary parameters. For cluster-scoped mappings, specifying owner.uuid or owner.name is not required.

### Required properties
* `address` - IPv4/IPv6 address in dotted form.
* `hostname` - Canonical hostname.
### Optional properties
* `owner.uuid` or `owner.name` - Specify the name or UUID of an existing SVM to create an SVM-scoped IP-to-host mapping.
* `aliases` - The list of aliases.
### Related ONTAP commands
* `vserver services name-service dns hosts create`
### Learn more
* [`DOC /name-services/local-hosts`](#docs-name-services-name-services_local-hosts)
*/
func (a *Client) LocalHostCreate(params *LocalHostCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_create",
		Method:             "POST",
		PathPattern:        "/name-services/local-hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalHostDelete Deletes an existing host object.

### Related ONTAP commands
* `vserver services name-service dns hosts delete`
### Learn more
* [`DOC /name-services/local-hosts`](#docs-name-services-name-services_local-hosts)
*/
func (a *Client) LocalHostDelete(params *LocalHostDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/local-hosts/{owner.uuid}/{address}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalHostDeleteCollection local host delete collection API
*/
func (a *Client) LocalHostDeleteCollection(params *LocalHostDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/local-hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalHostGet For a specified SVM and IP address, returns the corresponding IP to hostname mapping.

### Related ONTAP commands
* `vserver services name-service dns hosts show`
### Learn more
* [`DOC /name-services/local-hosts`](#docs-name-services-name-services_local-hosts)
*/
func (a *Client) LocalHostGet(params *LocalHostGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_get",
		Method:             "GET",
		PathPattern:        "/name-services/local-hosts/{owner.uuid}/{address}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalHostModify For a specified SVM and IP address, modifies the corresponding IP to hostname mapping.

### Related ONTAP commands
* `vserver services name-service dns hosts modify`
### Learn more
* [`DOC /name-services/local-hosts`](#docs-name-services-name-services_local-hosts)
*/
func (a *Client) LocalHostModify(params *LocalHostModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/local-hosts/{owner.uuid}/{address}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalHostModifyCollection local host modify collection API
*/
func (a *Client) LocalHostModifyCollection(params *LocalHostModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalHostModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalHostModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_host_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/local-hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalHostModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalHostModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalHostModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NameMappingCollectionGet Retrieves the name mapping configuration for all SVMs.

### Related ONTAP commands
* `vserver name-mapping show`
### Learn more
* [`DOC /name-services/name-mappings`](#docs-name-services-name-services_name-mappings)
*/
func (a *Client) NameMappingCollectionGet(params *NameMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/name-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NameMappingCreate Creates name mappings for an SVM.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the name mapping.
* `index` - Name mapping's position in the priority list.
* `direction` - Direction of the name mapping.
* `pattern` - Pattern to match to. Maximum length is 256 characters.
* `replacement` - Replacement pattern to match to. Maximum length is 256 characters.
### Recommended optional properties
* `client_match` - Hostname or IP address added to match the pattern to the client's workstation IP address.
### Related ONTAP commands
* `vserver name-mapping create`
* `vserver name-mapping insert`
### Learn more
* [`DOC /name-services/name-mappings`](#docs-name-services-name-services_name-mappings)
*/
func (a *Client) NameMappingCreate(params *NameMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_create",
		Method:             "POST",
		PathPattern:        "/name-services/name-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NameMappingDelete Deletes the name mapping configuration.

### Related ONTAP commands
* `vserver name-mapping delete`
### Learn more
* [`DOC /name-services/name-mappings`](#docs-name-services-name-services_name-mappings)
*/
func (a *Client) NameMappingDelete(params *NameMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/name-mappings/{svm.uuid}/{direction}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NameMappingDeleteCollection name mapping delete collection API
*/
func (a *Client) NameMappingDeleteCollection(params *NameMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/name-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NameMappingModify Updates the name mapping configuration of an SVM. The positions can be swapped by providing the `new_index` property.

Swapping is not allowed for entries that have `client_match` property configured.
### Related ONTAP commands
* `vserver name-mapping modify`
* `vserver name-mapping swap`
### Learn more
* [`DOC /name-services/name-mappings`](#docs-name-services-name-services_name-mappings)
*/
func (a *Client) NameMappingModify(params *NameMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/name-mappings/{svm.uuid}/{direction}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NameMappingModifyCollection name mapping modify collection API
*/
func (a *Client) NameMappingModifyCollection(params *NameMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/name-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NameMappingPositionGet Retrieves the name mapping configuration of an SVM.

### Related ONTAP commands
* `vserver name-mapping show`
### Learn more
* [`DOC /name-services/name-mappings`](#docs-name-services-name-services_name-mappings)
*/
func (a *Client) NameMappingPositionGet(params *NameMappingPositionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NameMappingPositionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNameMappingPositionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "name_mapping_position_get",
		Method:             "GET",
		PathPattern:        "/name-services/name-mappings/{svm.uuid}/{direction}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NameMappingPositionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NameMappingPositionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NameMappingPositionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetgroupFileDelete Deletes the netgroup file for a given SVM.

### Related ONTAP commands
* `vserver services name-service netgroup file delete`
### Learn more
* [`DOC /name-services/netgroup-files/{svm.uuid}`](#docs-name-services-name-services_netgroup-files_{svm.uuid})
*/
func (a *Client) NetgroupFileDelete(params *NetgroupFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupFileDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupFileDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroup_file_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/netgroup-files/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupFileDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupFileDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupFileDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetgroupFileGet Retrieves the netgroup file details for a given SVM if the header is set as "accept: application/json".

If the header is set as "accept: multipart/form-data", the raw netgroup file of the given SVM is retrieved.
### Important notes
* For a raw netgroup file, set the header as "accept: multipart/form-data" else "accept: application/json" for netgroup file details.
* Maximum size supported for raw netgroup file is 5MB, but netgroup file details of any valid SVM can be retrieved if present.
### Related ONTAP commands
* `vserver services name-service netgroup status`
* `vserver services name-service netgroup file show`
### Learn more
* [`DOC /name-services/netgroup-files/{svm.uuid}`](#docs-name-services-name-services_netgroup-files_{svm.uuid})
*/
func (a *Client) NetgroupFileGet(params *NetgroupFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupFileGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupFileGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroup_file_get",
		Method:             "GET",
		PathPattern:        "/name-services/netgroup-files/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupFileGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupFileGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupFileGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetgroupsSettingsCollectionGet Retrieves netgroups cache settings.

### Related ONTAP commands
* `vserver services name-service cache netgroups settings show`
### Learn more
* [`DOC /name-services/cache/netgroup/settings`](#docs-name-services-name-services_cache_netgroup_settings)
*/
func (a *Client) NetgroupsSettingsCollectionGet(params *NetgroupsSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupsSettingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroups_settings_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/netgroup/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupsSettingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupsSettingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupsSettingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetgroupsSettingsGet Retrieves a netgroup cache setting for a given SVM.

### Related ONTAP commands
* `vserver services name-service cache netgroups settings show`
### Learn more
* [`DOC /name-services/cache/netgroup/settings`](#docs-name-services-name-services_cache_netgroup_settings)
*/
func (a *Client) NetgroupsSettingsGet(params *NetgroupsSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupsSettingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroups_settings_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/netgroup/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupsSettingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupsSettingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupsSettingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetgroupsSettingsModify Updates a netgroup cache setting.

### Important notes
  - svm.uuid field cannot be empty.
  - Returns success in case no values are provided for update.

### Related ONTAP commands
* `vserver services name-service cache netgroups settings modify`
### Learn more
* [`DOC /name-services/cache/netgroup/settings`](#docs-name-services-name-services_cache_netgroup_settings)
*/
func (a *Client) NetgroupsSettingsModify(params *NetgroupsSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupsSettingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroups_settings_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/netgroup/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupsSettingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupsSettingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupsSettingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetgroupsSettingsModifyCollection netgroups settings modify collection API
*/
func (a *Client) NetgroupsSettingsModifyCollection(params *NetgroupsSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetgroupsSettingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetgroupsSettingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netgroups_settings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/netgroup/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetgroupsSettingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetgroupsSettingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetgroupsSettingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NisCollectionGet Retrieves NIS domain configurations of all the SVMs. The bound_servers field indicates the successfully bound NIS servers. Lookups and authentications fail if there are no bound servers.

### Related ONTAP commands
* `vserver services name-service nis-domain show`
* `vserver services name-service nis-domain show-bound`
* `vserver services name-service nis-domain show-bound-debug`
### Learn more
* [`DOC /name-services/nis`](#docs-name-services-name-services_nis)
*/
func (a *Client) NisCollectionGet(params *NisCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NisCreate Creates an NIS domain and server configuration for a data SVM.

NIS configuration for the cluster is managed via [`/api/security/authentication/cluster/nis`](#docs-security-security_authentication_cluster_nis).<br/>
### Important notes
  - Each SVM can have one NIS domain configuration.
  - Multiple SVMs can be configured with the same NIS domain. Specify the NIS domain and NIS servers as input.Domain name and servers fields cannot be empty.
  - Both FQDNs and IP addresses are supported for the servers field.
  - IPv6 must be enabled if IPv6 family addresses are specified in the servers field.
  - A maximum of ten NIS servers are supported.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the NIS configuration.
* `domain` - NIS domain to which the configuration belongs.
* `servers` - List of NIS server IP addresses.
### Related ONTAP commands
* `vserver services name-service nis-domain create`
### Learn more
* [`DOC /name-services/nis`](#docs-name-services-name-services_nis)
*/
func (a *Client) NisCreate(params *NisCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_create",
		Method:             "POST",
		PathPattern:        "/name-services/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NisDelete Deletes the NIS domain configuration of an SVM. NIS can be removed as a source from ns-switch if NIS is not used for lookups.

### Related ONTAP commands
* `vserver services name-service nis-domain delete`
### Learn more
* [`DOC /name-services/nis`](#docs-name-services-name-services_nis)
*/
func (a *Client) NisDelete(params *NisDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/nis/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NisDeleteCollection nis delete collection API
*/
func (a *Client) NisDeleteCollection(params *NisDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NisGet Retrieves NIS domain and server configurations of an SVM. Both NIS domain and servers are displayed by default. The bound_servers field indicates the successfully bound NIS servers.

### Related ONTAP commands
* `vserver services name-service nis-domain show`
* `vserver services name-service nis-domain show-bound`
* `vserver services name-service nis-domain show-bound-debug`
### Learn more
* [`DOC /name-services/nis`](#docs-name-services-name-services_nis)
*/
func (a *Client) NisGet(params *NisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_get",
		Method:             "GET",
		PathPattern:        "/name-services/nis/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NisModify Updates NIS domain and server configuration of an SVM.<br/>

### Important notes
  - Both NIS domain and servers can be modified.
  - Domains and servers cannot be empty.
  - Both FQDNs and IP addresses are supported for the servers field.
  - If the domain is modified, NIS servers must also be specified.
  - IPv6 must be enabled if IPv6 family addresses are specified for the servers field.

### Related ONTAP commands
* `vserver services name-service nis-domain modify`
### Learn more
* [`DOC /name-services/nis`](#docs-name-services-name-services_nis)
*/
func (a *Client) NisModify(params *NisModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/nis/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NisModifyCollection nis modify collection API
*/
func (a *Client) NisModifyCollection(params *NisModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NisModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNisModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nis_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NisModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NisModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NisModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupCollectionGet Retrieves the UNIX groups for all of the SVMs. UNIX users who are the members of the group are also displayed.

### Related ONTAP commands
* `vserver services name-service unix-group show`
### Learn more
* [`DOC /name-services/unix-groups`](#docs-name-services-name-services_unix-groups)
*/
func (a *Client) UnixGroupCollectionGet(params *UnixGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupCreate Creates the local UNIX group configuration for the specified SVM.<br/>

Group name and group ID are mandatory parameters.
### Important notes
* The default limit for local UNIX groups and group members is 32768.
### Learn more
* [`DOC /name-services/unix-groups`](#docs-name-services-name-services_unix-groups)
*/
func (a *Client) UnixGroupCreate(params *UnixGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_create",
		Method:             "POST",
		PathPattern:        "/name-services/unix-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupDelete Deletes a UNIX group configuration for the specified SVM.

### Related ONTAP commands
* `vserver services name-service unix-group delete`
### Learn more
* [`DOC /name-services/unix-groups`](#docs-name-services-name-services_unix-groups)
*/
func (a *Client) UnixGroupDelete(params *UnixGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixGroupDeleteCollection unix group delete collection API
*/
func (a *Client) UnixGroupDeleteCollection(params *UnixGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupGet Retrieves UNIX group information for the specified group and SVM. UNIX users who are part of this group

are also retrieved.
### Related ONTAP commands
* `vserver services name-service unix-group show`
### Learn more
* [`DOC /name-services/unix-groups`](#docs-name-services-name-services_unix-groups)
*/
func (a *Client) UnixGroupGet(params *UnixGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupModify Updates the UNIX group information of the specified group in the specified SVM.

### Learn more
* [`DOC /name-services/unix-groups`](#docs-name-services-name-services_unix-groups)
*/
func (a *Client) UnixGroupModify(params *UnixGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixGroupModifyCollection unix group modify collection API
*/
func (a *Client) UnixGroupModifyCollection(params *UnixGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/unix-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupSettingsCollectionGet Retrieves unix-group cache settings.

### Related ONTAP commands
* `vserver services name-service cache unix-group settings show`
### Learn more
* [`DOC /name-services/cache/unix-group/settings`](#docs-name-services-name-services_cache_unix-group_settings)
*/
func (a *Client) UnixGroupSettingsCollectionGet(params *UnixGroupSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupSettingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_settings_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/unix-group/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupSettingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupSettingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupSettingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupSettingsGet Retrieves a unix-group cache setting for a given SVM.

### Related ONTAP commands
* `vserver services name-service cache unix-group settings show`
### Learn more
* [`DOC /name-services/cache/unix-group/settings`](#docs-name-services-name-services_cache_unix-group_settings)
*/
func (a *Client) UnixGroupSettingsGet(params *UnixGroupSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupSettingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_settings_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/unix-group/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupSettingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupSettingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupSettingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupSettingsModify Updates unix-group cache settings.

### Important notes
  - svm.uuid field cannot be empty.
  - Returns success in case no values are provided for update.

### Related ONTAP commands
* `vserver services name-service cache unix-group settings modify`
### Learn more
* [`DOC /name-services/cache/unix-group/settings`](#docs-name-services-name-services_cache_unix-group_settings)
*/
func (a *Client) UnixGroupSettingsModify(params *UnixGroupSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupSettingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_settings_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/unix-group/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupSettingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupSettingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupSettingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixGroupSettingsModifyCollection unix group settings modify collection API
*/
func (a *Client) UnixGroupSettingsModifyCollection(params *UnixGroupSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupSettingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupSettingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_settings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/unix-group/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupSettingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupSettingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupSettingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupUserDelete Deletes a user from the specified UNIX group.

### Related ONTAP commands
* `vserver services name-service unix-group deluser`
*/
func (a *Client) UnixGroupUserDelete(params *UnixGroupUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUserDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupUserDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_user_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupUserDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupUserDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupUserDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixGroupUserDeleteCollection unix group user delete collection API
*/
func (a *Client) UnixGroupUserDeleteCollection(params *UnixGroupUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUserDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupUserDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_user_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{unix_group.name}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupUserDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupUserDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupUserDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupUsersCollectionGet Retrieves users for the specified UNIX group and SVM.

### Related ONTAP commands
* `vserver services name-service unix-group show`
*/
func (a *Client) UnixGroupUsersCollectionGet(params *UnixGroupUsersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupUsersCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_users_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{unix_group.name}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupUsersCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupUsersCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupUsersCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupUsersCreate Adds users to the specified UNIX group and SVM.

### Important notes
- Multiple users can be added in a single call using the "records" parameter.
- "records" parameter must not be specified when "name" parameter is specified.
- Specified users are appended to the existing list of users.
- Duplicate users are ignored.
### Related ONTAP commands
* `vserver services name-service unix-group adduser`
* `vserver services name-service unix-group addusers`
*/
func (a *Client) UnixGroupUsersCreate(params *UnixGroupUsersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupUsersCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_users_create",
		Method:             "POST",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{unix_group.name}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupUsersCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupUsersCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupUsersCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixGroupUsersGet Retrieves users for the specified UNIX group and SVM.

### Related ONTAP commands
* `vserver services name-service unix-group show`
*/
func (a *Client) UnixGroupUsersGet(params *UnixGroupUsersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixGroupUsersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixGroupUsersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_group_users_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixGroupUsersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixGroupUsersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixGroupUsersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserCollectionGet Retrieves all of the UNIX users for all of the SVMs.

### Important notes
* The current UNIX users count can be retrieved from the num_records field by calling the API with the parameter "return_records=false".
### Related ONTAP commands
* `vserver services name-service unix-user show`
*/
func (a *Client) UnixUserCollectionGet(params *UnixUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserCreate Creates the local UNIX user configuration for an SVM.<br/>

### Important notes
* The default limit for local UNIX users is 32768.
*/
func (a *Client) UnixUserCreate(params *UnixUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_create",
		Method:             "POST",
		PathPattern:        "/name-services/unix-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserDelete Deletes a UNIX user configuration for the specified SVM.

### Related ONTAP commands
* `vserver services name-service unix-user delete`
*/
func (a *Client) UnixUserDelete(params *UnixUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_delete",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-users/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixUserDeleteCollection unix user delete collection API
*/
func (a *Client) UnixUserDeleteCollection(params *UnixUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/name-services/unix-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserGet Retrieves UNIX user information for the specified user and SVM.

### Related ONTAP commands
* `vserver services name-service unix-user show`
*/
func (a *Client) UnixUserGet(params *UnixUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_get",
		Method:             "GET",
		PathPattern:        "/name-services/unix-users/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixUserModify Updates UNIX user information for the specified user and SVM.
*/
func (a *Client) UnixUserModify(params *UnixUserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/unix-users/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixUserModifyCollection unix user modify collection API
*/
func (a *Client) UnixUserModifyCollection(params *UnixUserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/unix-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserSettingsCollectionGet Retrieves unix-user cache settings.

### Related ONTAP commands
* `vserver services name-service cache unix-user settings show`
### Learn more
* [`DOC /name-services/cache/unix-user/settings`](#docs-name-services-name-services_cache_unix-user_settings)
*/
func (a *Client) UnixUserSettingsCollectionGet(params *UnixUserSettingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserSettingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_settings_collection_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/unix-user/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserSettingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserSettingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserSettingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserSettingsGet Retrieves unix-user cache settings for a given SVM.

### Related ONTAP commands
* `vserver services name-service cache unix-user settings show`
### Learn more
* [`DOC /name-services/cache/unix-user/settings`](#docs-name-services-name-services_cache_unix-user_settings)
*/
func (a *Client) UnixUserSettingsGet(params *UnixUserSettingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserSettingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_settings_get",
		Method:             "GET",
		PathPattern:        "/name-services/cache/unix-user/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserSettingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserSettingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserSettingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UnixUserSettingsModify Updates a unix-user cache setting.

### Important notes
  - svm.uuid field cannot be empty.
  - Returns success in case no values are provided for update.

### Related ONTAP commands
* `vserver services name-service cache unix-user settings modify`
### Learn more
* [`DOC /name-services/cache/unix-user/settings`](#docs-name-services-name-services_cache_unix-user_settings)
*/
func (a *Client) UnixUserSettingsModify(params *UnixUserSettingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserSettingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_settings_modify",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/unix-user/settings/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserSettingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserSettingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserSettingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnixUserSettingsModifyCollection unix user settings modify collection API
*/
func (a *Client) UnixUserSettingsModifyCollection(params *UnixUserSettingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnixUserSettingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnixUserSettingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unix_user_settings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/name-services/cache/unix-user/settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UnixUserSettingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnixUserSettingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnixUserSettingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
