// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewNetgroupFileDeleteParams creates a new NetgroupFileDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetgroupFileDeleteParams() *NetgroupFileDeleteParams {
	return &NetgroupFileDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetgroupFileDeleteParamsWithTimeout creates a new NetgroupFileDeleteParams object
// with the ability to set a timeout on a request.
func NewNetgroupFileDeleteParamsWithTimeout(timeout time.Duration) *NetgroupFileDeleteParams {
	return &NetgroupFileDeleteParams{
		timeout: timeout,
	}
}

// NewNetgroupFileDeleteParamsWithContext creates a new NetgroupFileDeleteParams object
// with the ability to set a context for a request.
func NewNetgroupFileDeleteParamsWithContext(ctx context.Context) *NetgroupFileDeleteParams {
	return &NetgroupFileDeleteParams{
		Context: ctx,
	}
}

// NewNetgroupFileDeleteParamsWithHTTPClient creates a new NetgroupFileDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetgroupFileDeleteParamsWithHTTPClient(client *http.Client) *NetgroupFileDeleteParams {
	return &NetgroupFileDeleteParams{
		HTTPClient: client,
	}
}

/*
NetgroupFileDeleteParams contains all the parameters to send to the API endpoint

	for the netgroup file delete operation.

	Typically these are written to a http.Request.
*/
type NetgroupFileDeleteParams struct {

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the netgroup file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupFileDeleteParams) WithDefaults() *NetgroupFileDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the netgroup file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupFileDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the netgroup file delete params
func (o *NetgroupFileDeleteParams) WithTimeout(timeout time.Duration) *NetgroupFileDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the netgroup file delete params
func (o *NetgroupFileDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the netgroup file delete params
func (o *NetgroupFileDeleteParams) WithContext(ctx context.Context) *NetgroupFileDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the netgroup file delete params
func (o *NetgroupFileDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the netgroup file delete params
func (o *NetgroupFileDeleteParams) WithHTTPClient(client *http.Client) *NetgroupFileDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the netgroup file delete params
func (o *NetgroupFileDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithSvmUUID adds the svmUUID to the netgroup file delete params
func (o *NetgroupFileDeleteParams) WithSvmUUID(svmUUID string) *NetgroupFileDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the netgroup file delete params
func (o *NetgroupFileDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NetgroupFileDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
