// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetgroupFileDeleteReader is a Reader for the NetgroupFileDelete structure.
type NetgroupFileDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetgroupFileDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetgroupFileDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetgroupFileDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetgroupFileDeleteOK creates a NetgroupFileDeleteOK with default headers values
func NewNetgroupFileDeleteOK() *NetgroupFileDeleteOK {
	return &NetgroupFileDeleteOK{}
}

/*
NetgroupFileDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NetgroupFileDeleteOK struct {
}

// IsSuccess returns true when this netgroup file delete o k response has a 2xx status code
func (o *NetgroupFileDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this netgroup file delete o k response has a 3xx status code
func (o *NetgroupFileDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this netgroup file delete o k response has a 4xx status code
func (o *NetgroupFileDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this netgroup file delete o k response has a 5xx status code
func (o *NetgroupFileDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this netgroup file delete o k response a status code equal to that given
func (o *NetgroupFileDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the netgroup file delete o k response
func (o *NetgroupFileDeleteOK) Code() int {
	return 200
}

func (o *NetgroupFileDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/netgroup-files/{svm.uuid}][%d] netgroupFileDeleteOK", 200)
}

func (o *NetgroupFileDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/netgroup-files/{svm.uuid}][%d] netgroupFileDeleteOK", 200)
}

func (o *NetgroupFileDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetgroupFileDeleteDefault creates a NetgroupFileDeleteDefault with default headers values
func NewNetgroupFileDeleteDefault(code int) *NetgroupFileDeleteDefault {
	return &NetgroupFileDeleteDefault{
		_statusCode: code,
	}
}

/*
NetgroupFileDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type NetgroupFileDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this netgroup file delete default response has a 2xx status code
func (o *NetgroupFileDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this netgroup file delete default response has a 3xx status code
func (o *NetgroupFileDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this netgroup file delete default response has a 4xx status code
func (o *NetgroupFileDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this netgroup file delete default response has a 5xx status code
func (o *NetgroupFileDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this netgroup file delete default response a status code equal to that given
func (o *NetgroupFileDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the netgroup file delete default response
func (o *NetgroupFileDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NetgroupFileDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/netgroup-files/{svm.uuid}][%d] netgroup_file_delete default %s", o._statusCode, payload)
}

func (o *NetgroupFileDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/netgroup-files/{svm.uuid}][%d] netgroup_file_delete default %s", o._statusCode, payload)
}

func (o *NetgroupFileDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetgroupFileDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
