// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetgroupFileGetParams creates a new NetgroupFileGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetgroupFileGetParams() *NetgroupFileGetParams {
	return &NetgroupFileGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetgroupFileGetParamsWithTimeout creates a new NetgroupFileGetParams object
// with the ability to set a timeout on a request.
func NewNetgroupFileGetParamsWithTimeout(timeout time.Duration) *NetgroupFileGetParams {
	return &NetgroupFileGetParams{
		timeout: timeout,
	}
}

// NewNetgroupFileGetParamsWithContext creates a new NetgroupFileGetParams object
// with the ability to set a context for a request.
func NewNetgroupFileGetParamsWithContext(ctx context.Context) *NetgroupFileGetParams {
	return &NetgroupFileGetParams{
		Context: ctx,
	}
}

// NewNetgroupFileGetParamsWithHTTPClient creates a new NetgroupFileGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetgroupFileGetParamsWithHTTPClient(client *http.Client) *NetgroupFileGetParams {
	return &NetgroupFileGetParams{
		HTTPClient: client,
	}
}

/*
NetgroupFileGetParams contains all the parameters to send to the API endpoint

	for the netgroup file get operation.

	Typically these are written to a http.Request.
*/
type NetgroupFileGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the netgroup file get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupFileGetParams) WithDefaults() *NetgroupFileGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the netgroup file get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupFileGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the netgroup file get params
func (o *NetgroupFileGetParams) WithTimeout(timeout time.Duration) *NetgroupFileGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the netgroup file get params
func (o *NetgroupFileGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the netgroup file get params
func (o *NetgroupFileGetParams) WithContext(ctx context.Context) *NetgroupFileGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the netgroup file get params
func (o *NetgroupFileGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the netgroup file get params
func (o *NetgroupFileGetParams) WithHTTPClient(client *http.Client) *NetgroupFileGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the netgroup file get params
func (o *NetgroupFileGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the netgroup file get params
func (o *NetgroupFileGetParams) WithFields(fields []string) *NetgroupFileGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the netgroup file get params
func (o *NetgroupFileGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the netgroup file get params
func (o *NetgroupFileGetParams) WithSvmUUID(svmUUID string) *NetgroupFileGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the netgroup file get params
func (o *NetgroupFileGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NetgroupFileGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetgroupFileGet binds the parameter fields
func (o *NetgroupFileGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
