// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetgroupsSettingsGetParams creates a new NetgroupsSettingsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetgroupsSettingsGetParams() *NetgroupsSettingsGetParams {
	return &NetgroupsSettingsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetgroupsSettingsGetParamsWithTimeout creates a new NetgroupsSettingsGetParams object
// with the ability to set a timeout on a request.
func NewNetgroupsSettingsGetParamsWithTimeout(timeout time.Duration) *NetgroupsSettingsGetParams {
	return &NetgroupsSettingsGetParams{
		timeout: timeout,
	}
}

// NewNetgroupsSettingsGetParamsWithContext creates a new NetgroupsSettingsGetParams object
// with the ability to set a context for a request.
func NewNetgroupsSettingsGetParamsWithContext(ctx context.Context) *NetgroupsSettingsGetParams {
	return &NetgroupsSettingsGetParams{
		Context: ctx,
	}
}

// NewNetgroupsSettingsGetParamsWithHTTPClient creates a new NetgroupsSettingsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetgroupsSettingsGetParamsWithHTTPClient(client *http.Client) *NetgroupsSettingsGetParams {
	return &NetgroupsSettingsGetParams{
		HTTPClient: client,
	}
}

/*
NetgroupsSettingsGetParams contains all the parameters to send to the API endpoint

	for the netgroups settings get operation.

	Typically these are written to a http.Request.
*/
type NetgroupsSettingsGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NegativeCacheEnabledByhost.

	   Filter by negative_cache_enabled_byhost
	*/
	NegativeCacheEnabledByhost *bool

	/* NegativeTTLByhost.

	   Filter by negative_ttl_byhost
	*/
	NegativeTTLByhost *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   SVM UUID.
	*/
	SvmUUID string

	/* TTLByhost.

	   Filter by ttl_byhost
	*/
	TTLByhost *string

	/* TTLForMembers.

	   Filter by ttl_for_members
	*/
	TTLForMembers *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the netgroups settings get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupsSettingsGetParams) WithDefaults() *NetgroupsSettingsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the netgroups settings get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupsSettingsGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NetgroupsSettingsGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithTimeout(timeout time.Duration) *NetgroupsSettingsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithContext(ctx context.Context) *NetgroupsSettingsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithHTTPClient(client *http.Client) *NetgroupsSettingsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithEnabled(enabled *bool) *NetgroupsSettingsGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithFields(fields []string) *NetgroupsSettingsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithMaxRecords(maxRecords *int64) *NetgroupsSettingsGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNegativeCacheEnabledByhost adds the negativeCacheEnabledByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithNegativeCacheEnabledByhost(negativeCacheEnabledByhost *bool) *NetgroupsSettingsGetParams {
	o.SetNegativeCacheEnabledByhost(negativeCacheEnabledByhost)
	return o
}

// SetNegativeCacheEnabledByhost adds the negativeCacheEnabledByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetNegativeCacheEnabledByhost(negativeCacheEnabledByhost *bool) {
	o.NegativeCacheEnabledByhost = negativeCacheEnabledByhost
}

// WithNegativeTTLByhost adds the negativeTTLByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithNegativeTTLByhost(negativeTTLByhost *string) *NetgroupsSettingsGetParams {
	o.SetNegativeTTLByhost(negativeTTLByhost)
	return o
}

// SetNegativeTTLByhost adds the negativeTtlByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetNegativeTTLByhost(negativeTTLByhost *string) {
	o.NegativeTTLByhost = negativeTTLByhost
}

// WithOrderBy adds the orderBy to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithOrderBy(orderBy []string) *NetgroupsSettingsGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithReturnRecords(returnRecords *bool) *NetgroupsSettingsGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithReturnTimeout(returnTimeout *int64) *NetgroupsSettingsGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithSvmName(svmName *string) *NetgroupsSettingsGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithSvmUUID(svmUUID string) *NetgroupsSettingsGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTTLByhost adds the tTLByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithTTLByhost(tTLByhost *string) *NetgroupsSettingsGetParams {
	o.SetTTLByhost(tTLByhost)
	return o
}

// SetTTLByhost adds the ttlByhost to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetTTLByhost(tTLByhost *string) {
	o.TTLByhost = tTLByhost
}

// WithTTLForMembers adds the tTLForMembers to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) WithTTLForMembers(tTLForMembers *string) *NetgroupsSettingsGetParams {
	o.SetTTLForMembers(tTLForMembers)
	return o
}

// SetTTLForMembers adds the ttlForMembers to the netgroups settings get params
func (o *NetgroupsSettingsGetParams) SetTTLForMembers(tTLForMembers *string) {
	o.TTLForMembers = tTLForMembers
}

// WriteToRequest writes these params to a swagger request
func (o *NetgroupsSettingsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NegativeCacheEnabledByhost != nil {

		// query param negative_cache_enabled_byhost
		var qrNegativeCacheEnabledByhost bool

		if o.NegativeCacheEnabledByhost != nil {
			qrNegativeCacheEnabledByhost = *o.NegativeCacheEnabledByhost
		}
		qNegativeCacheEnabledByhost := swag.FormatBool(qrNegativeCacheEnabledByhost)
		if qNegativeCacheEnabledByhost != "" {

			if err := r.SetQueryParam("negative_cache_enabled_byhost", qNegativeCacheEnabledByhost); err != nil {
				return err
			}
		}
	}

	if o.NegativeTTLByhost != nil {

		// query param negative_ttl_byhost
		var qrNegativeTTLByhost string

		if o.NegativeTTLByhost != nil {
			qrNegativeTTLByhost = *o.NegativeTTLByhost
		}
		qNegativeTTLByhost := qrNegativeTTLByhost
		if qNegativeTTLByhost != "" {

			if err := r.SetQueryParam("negative_ttl_byhost", qNegativeTTLByhost); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.TTLByhost != nil {

		// query param ttl_byhost
		var qrTTLByhost string

		if o.TTLByhost != nil {
			qrTTLByhost = *o.TTLByhost
		}
		qTTLByhost := qrTTLByhost
		if qTTLByhost != "" {

			if err := r.SetQueryParam("ttl_byhost", qTTLByhost); err != nil {
				return err
			}
		}
	}

	if o.TTLForMembers != nil {

		// query param ttl_for_members
		var qrTTLForMembers string

		if o.TTLForMembers != nil {
			qrTTLForMembers = *o.TTLForMembers
		}
		qTTLForMembers := qrTTLForMembers
		if qTTLForMembers != "" {

			if err := r.SetQueryParam("ttl_for_members", qTTLForMembers); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetgroupsSettingsGet binds the parameter fields
func (o *NetgroupsSettingsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNetgroupsSettingsGet binds the parameter order_by
func (o *NetgroupsSettingsGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
