// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetgroupsSettingsGetReader is a Reader for the NetgroupsSettingsGet structure.
type NetgroupsSettingsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetgroupsSettingsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetgroupsSettingsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetgroupsSettingsGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetgroupsSettingsGetOK creates a NetgroupsSettingsGetOK with default headers values
func NewNetgroupsSettingsGetOK() *NetgroupsSettingsGetOK {
	return &NetgroupsSettingsGetOK{}
}

/*
NetgroupsSettingsGetOK describes a response with status code 200, with default header values.

OK
*/
type NetgroupsSettingsGetOK struct {
	Payload *models.NetgroupsSettings
}

// IsSuccess returns true when this netgroups settings get o k response has a 2xx status code
func (o *NetgroupsSettingsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this netgroups settings get o k response has a 3xx status code
func (o *NetgroupsSettingsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this netgroups settings get o k response has a 4xx status code
func (o *NetgroupsSettingsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this netgroups settings get o k response has a 5xx status code
func (o *NetgroupsSettingsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this netgroups settings get o k response a status code equal to that given
func (o *NetgroupsSettingsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the netgroups settings get o k response
func (o *NetgroupsSettingsGetOK) Code() int {
	return 200
}

func (o *NetgroupsSettingsGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/netgroup/settings/{svm.uuid}][%d] netgroupsSettingsGetOK %s", 200, payload)
}

func (o *NetgroupsSettingsGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/netgroup/settings/{svm.uuid}][%d] netgroupsSettingsGetOK %s", 200, payload)
}

func (o *NetgroupsSettingsGetOK) GetPayload() *models.NetgroupsSettings {
	return o.Payload
}

func (o *NetgroupsSettingsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NetgroupsSettings)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetgroupsSettingsGetDefault creates a NetgroupsSettingsGetDefault with default headers values
func NewNetgroupsSettingsGetDefault(code int) *NetgroupsSettingsGetDefault {
	return &NetgroupsSettingsGetDefault{
		_statusCode: code,
	}
}

/*
NetgroupsSettingsGetDefault describes a response with status code -1, with default header values.

Error
*/
type NetgroupsSettingsGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this netgroups settings get default response has a 2xx status code
func (o *NetgroupsSettingsGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this netgroups settings get default response has a 3xx status code
func (o *NetgroupsSettingsGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this netgroups settings get default response has a 4xx status code
func (o *NetgroupsSettingsGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this netgroups settings get default response has a 5xx status code
func (o *NetgroupsSettingsGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this netgroups settings get default response a status code equal to that given
func (o *NetgroupsSettingsGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the netgroups settings get default response
func (o *NetgroupsSettingsGetDefault) Code() int {
	return o._statusCode
}

func (o *NetgroupsSettingsGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/netgroup/settings/{svm.uuid}][%d] netgroups_settings_get default %s", o._statusCode, payload)
}

func (o *NetgroupsSettingsGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/netgroup/settings/{svm.uuid}][%d] netgroups_settings_get default %s", o._statusCode, payload)
}

func (o *NetgroupsSettingsGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetgroupsSettingsGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
