// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetgroupsSettingsModifyCollectionParams creates a new NetgroupsSettingsModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetgroupsSettingsModifyCollectionParams() *NetgroupsSettingsModifyCollectionParams {
	return &NetgroupsSettingsModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetgroupsSettingsModifyCollectionParamsWithTimeout creates a new NetgroupsSettingsModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNetgroupsSettingsModifyCollectionParamsWithTimeout(timeout time.Duration) *NetgroupsSettingsModifyCollectionParams {
	return &NetgroupsSettingsModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNetgroupsSettingsModifyCollectionParamsWithContext creates a new NetgroupsSettingsModifyCollectionParams object
// with the ability to set a context for a request.
func NewNetgroupsSettingsModifyCollectionParamsWithContext(ctx context.Context) *NetgroupsSettingsModifyCollectionParams {
	return &NetgroupsSettingsModifyCollectionParams{
		Context: ctx,
	}
}

// NewNetgroupsSettingsModifyCollectionParamsWithHTTPClient creates a new NetgroupsSettingsModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetgroupsSettingsModifyCollectionParamsWithHTTPClient(client *http.Client) *NetgroupsSettingsModifyCollectionParams {
	return &NetgroupsSettingsModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NetgroupsSettingsModifyCollectionParams contains all the parameters to send to the API endpoint

	for the netgroups settings modify collection operation.

	Typically these are written to a http.Request.
*/
type NetgroupsSettingsModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info NetgroupsSettingsModifyCollectionBody

	/* NegativeCacheEnabledByhost.

	   Filter by negative_cache_enabled_byhost
	*/
	NegativeCacheEnabledByhost *bool

	/* NegativeTTLByhost.

	   Filter by negative_ttl_byhost
	*/
	NegativeTTLByhost *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TTLByhost.

	   Filter by ttl_byhost
	*/
	TTLByhost *string

	/* TTLForMembers.

	   Filter by ttl_for_members
	*/
	TTLForMembers *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the netgroups settings modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupsSettingsModifyCollectionParams) WithDefaults() *NetgroupsSettingsModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the netgroups settings modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetgroupsSettingsModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NetgroupsSettingsModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithTimeout(timeout time.Duration) *NetgroupsSettingsModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithContext(ctx context.Context) *NetgroupsSettingsModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithHTTPClient(client *http.Client) *NetgroupsSettingsModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NetgroupsSettingsModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithEnabled(enabled *bool) *NetgroupsSettingsModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithInfo(info NetgroupsSettingsModifyCollectionBody) *NetgroupsSettingsModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetInfo(info NetgroupsSettingsModifyCollectionBody) {
	o.Info = info
}

// WithNegativeCacheEnabledByhost adds the negativeCacheEnabledByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithNegativeCacheEnabledByhost(negativeCacheEnabledByhost *bool) *NetgroupsSettingsModifyCollectionParams {
	o.SetNegativeCacheEnabledByhost(negativeCacheEnabledByhost)
	return o
}

// SetNegativeCacheEnabledByhost adds the negativeCacheEnabledByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetNegativeCacheEnabledByhost(negativeCacheEnabledByhost *bool) {
	o.NegativeCacheEnabledByhost = negativeCacheEnabledByhost
}

// WithNegativeTTLByhost adds the negativeTTLByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithNegativeTTLByhost(negativeTTLByhost *string) *NetgroupsSettingsModifyCollectionParams {
	o.SetNegativeTTLByhost(negativeTTLByhost)
	return o
}

// SetNegativeTTLByhost adds the negativeTtlByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetNegativeTTLByhost(negativeTTLByhost *string) {
	o.NegativeTTLByhost = negativeTTLByhost
}

// WithReturnRecords adds the returnRecords to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NetgroupsSettingsModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NetgroupsSettingsModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NetgroupsSettingsModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithSvmName(svmName *string) *NetgroupsSettingsModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithSvmUUID(svmUUID *string) *NetgroupsSettingsModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTTLByhost adds the tTLByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithTTLByhost(tTLByhost *string) *NetgroupsSettingsModifyCollectionParams {
	o.SetTTLByhost(tTLByhost)
	return o
}

// SetTTLByhost adds the ttlByhost to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetTTLByhost(tTLByhost *string) {
	o.TTLByhost = tTLByhost
}

// WithTTLForMembers adds the tTLForMembers to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) WithTTLForMembers(tTLForMembers *string) *NetgroupsSettingsModifyCollectionParams {
	o.SetTTLForMembers(tTLForMembers)
	return o
}

// SetTTLForMembers adds the ttlForMembers to the netgroups settings modify collection params
func (o *NetgroupsSettingsModifyCollectionParams) SetTTLForMembers(tTLForMembers *string) {
	o.TTLForMembers = tTLForMembers
}

// WriteToRequest writes these params to a swagger request
func (o *NetgroupsSettingsModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NegativeCacheEnabledByhost != nil {

		// query param negative_cache_enabled_byhost
		var qrNegativeCacheEnabledByhost bool

		if o.NegativeCacheEnabledByhost != nil {
			qrNegativeCacheEnabledByhost = *o.NegativeCacheEnabledByhost
		}
		qNegativeCacheEnabledByhost := swag.FormatBool(qrNegativeCacheEnabledByhost)
		if qNegativeCacheEnabledByhost != "" {

			if err := r.SetQueryParam("negative_cache_enabled_byhost", qNegativeCacheEnabledByhost); err != nil {
				return err
			}
		}
	}

	if o.NegativeTTLByhost != nil {

		// query param negative_ttl_byhost
		var qrNegativeTTLByhost string

		if o.NegativeTTLByhost != nil {
			qrNegativeTTLByhost = *o.NegativeTTLByhost
		}
		qNegativeTTLByhost := qrNegativeTTLByhost
		if qNegativeTTLByhost != "" {

			if err := r.SetQueryParam("negative_ttl_byhost", qNegativeTTLByhost); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TTLByhost != nil {

		// query param ttl_byhost
		var qrTTLByhost string

		if o.TTLByhost != nil {
			qrTTLByhost = *o.TTLByhost
		}
		qTTLByhost := qrTTLByhost
		if qTTLByhost != "" {

			if err := r.SetQueryParam("ttl_byhost", qTTLByhost); err != nil {
				return err
			}
		}
	}

	if o.TTLForMembers != nil {

		// query param ttl_for_members
		var qrTTLForMembers string

		if o.TTLForMembers != nil {
			qrTTLForMembers = *o.TTLForMembers
		}
		qTTLForMembers := qrTTLForMembers
		if qTTLForMembers != "" {

			if err := r.SetQueryParam("ttl_for_members", qTTLForMembers); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
