// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NisCreateReader is a Reader for the NisCreate structure.
type NisCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NisCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewNisCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNisCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNisCreateCreated creates a NisCreateCreated with default headers values
func NewNisCreateCreated() *NisCreateCreated {
	return &NisCreateCreated{}
}

/*
NisCreateCreated describes a response with status code 201, with default header values.

Created
*/
type NisCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.NisServiceResponse
}

// IsSuccess returns true when this nis create created response has a 2xx status code
func (o *NisCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nis create created response has a 3xx status code
func (o *NisCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nis create created response has a 4xx status code
func (o *NisCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this nis create created response has a 5xx status code
func (o *NisCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this nis create created response a status code equal to that given
func (o *NisCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the nis create created response
func (o *NisCreateCreated) Code() int {
	return 201
}

func (o *NisCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/nis][%d] nisCreateCreated %s", 201, payload)
}

func (o *NisCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/nis][%d] nisCreateCreated %s", 201, payload)
}

func (o *NisCreateCreated) GetPayload() *models.NisServiceResponse {
	return o.Payload
}

func (o *NisCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.NisServiceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNisCreateDefault creates a NisCreateDefault with default headers values
func NewNisCreateDefault(code int) *NisCreateDefault {
	return &NisCreateDefault{
		_statusCode: code,
	}
}

/*
	NisCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966253    | IPv6 is not enabled in the cluster |
| 2621488    | Invalid SVM context |
| 2621706    | The specified SVM UUID is incorrect for the specified SVM name |
| 3276964    | NIS domain name or NIS server domain is too long. The maximum supported for domain name is 64 characters and the maximum supported for NIS server domain is 255 characters |
| 3276933    | A maximum of 10 NIS servers can be configured per SVM |
| 13434916   | The SVM is in the process of being created. Wait a few minutes, and then try the command again. |
| 23724109   | DNS resolution failed for one or more specified servers  |
| 23724111   | Empty NIS servers cannot be specified.  |
| 23724112   | DNS resolution failed due to an internal error. Contact technical support if this issue persists  |
| 23724132   | DNS resolution failed for all the specified servers  |
| 23724130   | Cannot use an IPv6 name server address because there are no IPv6 LIFs |
*/
type NisCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nis create default response has a 2xx status code
func (o *NisCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nis create default response has a 3xx status code
func (o *NisCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nis create default response has a 4xx status code
func (o *NisCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nis create default response has a 5xx status code
func (o *NisCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nis create default response a status code equal to that given
func (o *NisCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nis create default response
func (o *NisCreateDefault) Code() int {
	return o._statusCode
}

func (o *NisCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/nis][%d] nis_create default %s", o._statusCode, payload)
}

func (o *NisCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/nis][%d] nis_create default %s", o._statusCode, payload)
}

func (o *NisCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NisCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
