// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNisDeleteCollectionParams creates a new NisDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNisDeleteCollectionParams() *NisDeleteCollectionParams {
	return &NisDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNisDeleteCollectionParamsWithTimeout creates a new NisDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewNisDeleteCollectionParamsWithTimeout(timeout time.Duration) *NisDeleteCollectionParams {
	return &NisDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewNisDeleteCollectionParamsWithContext creates a new NisDeleteCollectionParams object
// with the ability to set a context for a request.
func NewNisDeleteCollectionParamsWithContext(ctx context.Context) *NisDeleteCollectionParams {
	return &NisDeleteCollectionParams{
		Context: ctx,
	}
}

// NewNisDeleteCollectionParamsWithHTTPClient creates a new NisDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNisDeleteCollectionParamsWithHTTPClient(client *http.Client) *NisDeleteCollectionParams {
	return &NisDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
NisDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the nis delete collection operation.

	Typically these are written to a http.Request.
*/
type NisDeleteCollectionParams struct {

	/* BindingDetailsServer.

	   Filter by binding_details.server
	*/
	BindingDetailsServer *string

	/* BindingDetailsStatusCode.

	   Filter by binding_details.status.code
	*/
	BindingDetailsStatusCode *string

	/* BindingDetailsStatusMessage.

	   Filter by binding_details.status.message
	*/
	BindingDetailsStatusMessage *string

	/* BoundServers.

	   Filter by bound_servers
	*/
	BoundServers *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Domain.

	   Filter by domain
	*/
	Domain *string

	/* Info.

	   Info specification
	*/
	Info NisDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nis delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisDeleteCollectionParams) WithDefaults() *NisDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nis delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NisDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nis delete collection params
func (o *NisDeleteCollectionParams) WithTimeout(timeout time.Duration) *NisDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nis delete collection params
func (o *NisDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nis delete collection params
func (o *NisDeleteCollectionParams) WithContext(ctx context.Context) *NisDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nis delete collection params
func (o *NisDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nis delete collection params
func (o *NisDeleteCollectionParams) WithHTTPClient(client *http.Client) *NisDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nis delete collection params
func (o *NisDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBindingDetailsServer adds the bindingDetailsServer to the nis delete collection params
func (o *NisDeleteCollectionParams) WithBindingDetailsServer(bindingDetailsServer *string) *NisDeleteCollectionParams {
	o.SetBindingDetailsServer(bindingDetailsServer)
	return o
}

// SetBindingDetailsServer adds the bindingDetailsServer to the nis delete collection params
func (o *NisDeleteCollectionParams) SetBindingDetailsServer(bindingDetailsServer *string) {
	o.BindingDetailsServer = bindingDetailsServer
}

// WithBindingDetailsStatusCode adds the bindingDetailsStatusCode to the nis delete collection params
func (o *NisDeleteCollectionParams) WithBindingDetailsStatusCode(bindingDetailsStatusCode *string) *NisDeleteCollectionParams {
	o.SetBindingDetailsStatusCode(bindingDetailsStatusCode)
	return o
}

// SetBindingDetailsStatusCode adds the bindingDetailsStatusCode to the nis delete collection params
func (o *NisDeleteCollectionParams) SetBindingDetailsStatusCode(bindingDetailsStatusCode *string) {
	o.BindingDetailsStatusCode = bindingDetailsStatusCode
}

// WithBindingDetailsStatusMessage adds the bindingDetailsStatusMessage to the nis delete collection params
func (o *NisDeleteCollectionParams) WithBindingDetailsStatusMessage(bindingDetailsStatusMessage *string) *NisDeleteCollectionParams {
	o.SetBindingDetailsStatusMessage(bindingDetailsStatusMessage)
	return o
}

// SetBindingDetailsStatusMessage adds the bindingDetailsStatusMessage to the nis delete collection params
func (o *NisDeleteCollectionParams) SetBindingDetailsStatusMessage(bindingDetailsStatusMessage *string) {
	o.BindingDetailsStatusMessage = bindingDetailsStatusMessage
}

// WithBoundServers adds the boundServers to the nis delete collection params
func (o *NisDeleteCollectionParams) WithBoundServers(boundServers *string) *NisDeleteCollectionParams {
	o.SetBoundServers(boundServers)
	return o
}

// SetBoundServers adds the boundServers to the nis delete collection params
func (o *NisDeleteCollectionParams) SetBoundServers(boundServers *string) {
	o.BoundServers = boundServers
}

// WithContinueOnFailure adds the continueOnFailure to the nis delete collection params
func (o *NisDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NisDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the nis delete collection params
func (o *NisDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDomain adds the domain to the nis delete collection params
func (o *NisDeleteCollectionParams) WithDomain(domain *string) *NisDeleteCollectionParams {
	o.SetDomain(domain)
	return o
}

// SetDomain adds the domain to the nis delete collection params
func (o *NisDeleteCollectionParams) SetDomain(domain *string) {
	o.Domain = domain
}

// WithInfo adds the info to the nis delete collection params
func (o *NisDeleteCollectionParams) WithInfo(info NisDeleteCollectionBody) *NisDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nis delete collection params
func (o *NisDeleteCollectionParams) SetInfo(info NisDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the nis delete collection params
func (o *NisDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *NisDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nis delete collection params
func (o *NisDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nis delete collection params
func (o *NisDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *NisDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nis delete collection params
func (o *NisDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the nis delete collection params
func (o *NisDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *NisDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the nis delete collection params
func (o *NisDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServers adds the servers to the nis delete collection params
func (o *NisDeleteCollectionParams) WithServers(servers *string) *NisDeleteCollectionParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the nis delete collection params
func (o *NisDeleteCollectionParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithSvmName adds the svmName to the nis delete collection params
func (o *NisDeleteCollectionParams) WithSvmName(svmName *string) *NisDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nis delete collection params
func (o *NisDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nis delete collection params
func (o *NisDeleteCollectionParams) WithSvmUUID(svmUUID *string) *NisDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nis delete collection params
func (o *NisDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NisDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BindingDetailsServer != nil {

		// query param binding_details.server
		var qrBindingDetailsServer string

		if o.BindingDetailsServer != nil {
			qrBindingDetailsServer = *o.BindingDetailsServer
		}
		qBindingDetailsServer := qrBindingDetailsServer
		if qBindingDetailsServer != "" {

			if err := r.SetQueryParam("binding_details.server", qBindingDetailsServer); err != nil {
				return err
			}
		}
	}

	if o.BindingDetailsStatusCode != nil {

		// query param binding_details.status.code
		var qrBindingDetailsStatusCode string

		if o.BindingDetailsStatusCode != nil {
			qrBindingDetailsStatusCode = *o.BindingDetailsStatusCode
		}
		qBindingDetailsStatusCode := qrBindingDetailsStatusCode
		if qBindingDetailsStatusCode != "" {

			if err := r.SetQueryParam("binding_details.status.code", qBindingDetailsStatusCode); err != nil {
				return err
			}
		}
	}

	if o.BindingDetailsStatusMessage != nil {

		// query param binding_details.status.message
		var qrBindingDetailsStatusMessage string

		if o.BindingDetailsStatusMessage != nil {
			qrBindingDetailsStatusMessage = *o.BindingDetailsStatusMessage
		}
		qBindingDetailsStatusMessage := qrBindingDetailsStatusMessage
		if qBindingDetailsStatusMessage != "" {

			if err := r.SetQueryParam("binding_details.status.message", qBindingDetailsStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.BoundServers != nil {

		// query param bound_servers
		var qrBoundServers string

		if o.BoundServers != nil {
			qrBoundServers = *o.BoundServers
		}
		qBoundServers := qrBoundServers
		if qBoundServers != "" {

			if err := r.SetQueryParam("bound_servers", qBoundServers); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Domain != nil {

		// query param domain
		var qrDomain string

		if o.Domain != nil {
			qrDomain = *o.Domain
		}
		qDomain := qrDomain
		if qDomain != "" {

			if err := r.SetQueryParam("domain", qDomain); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
