// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NisDeleteCollectionReader is a Reader for the NisDeleteCollection structure.
type NisDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NisDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNisDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNisDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNisDeleteCollectionOK creates a NisDeleteCollectionOK with default headers values
func NewNisDeleteCollectionOK() *NisDeleteCollectionOK {
	return &NisDeleteCollectionOK{}
}

/*
NisDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NisDeleteCollectionOK struct {
}

// IsSuccess returns true when this nis delete collection o k response has a 2xx status code
func (o *NisDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nis delete collection o k response has a 3xx status code
func (o *NisDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nis delete collection o k response has a 4xx status code
func (o *NisDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nis delete collection o k response has a 5xx status code
func (o *NisDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nis delete collection o k response a status code equal to that given
func (o *NisDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nis delete collection o k response
func (o *NisDeleteCollectionOK) Code() int {
	return 200
}

func (o *NisDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/nis][%d] nisDeleteCollectionOK", 200)
}

func (o *NisDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/nis][%d] nisDeleteCollectionOK", 200)
}

func (o *NisDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNisDeleteCollectionDefault creates a NisDeleteCollectionDefault with default headers values
func NewNisDeleteCollectionDefault(code int) *NisDeleteCollectionDefault {
	return &NisDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
NisDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type NisDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nis delete collection default response has a 2xx status code
func (o *NisDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nis delete collection default response has a 3xx status code
func (o *NisDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nis delete collection default response has a 4xx status code
func (o *NisDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nis delete collection default response has a 5xx status code
func (o *NisDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nis delete collection default response a status code equal to that given
func (o *NisDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nis delete collection default response
func (o *NisDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NisDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/nis][%d] nis_delete_collection default %s", o._statusCode, payload)
}

func (o *NisDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/nis][%d] nis_delete_collection default %s", o._statusCode, payload)
}

func (o *NisDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NisDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NisDeleteCollectionBody nis delete collection body
swagger:model NisDeleteCollectionBody
*/
type NisDeleteCollectionBody struct {

	// nis service response inline records
	NisServiceResponseInlineRecords []*models.NisService `json:"records,omitempty"`
}

// Validate validates this nis delete collection body
func (o *NisDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNisServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisDeleteCollectionBody) validateNisServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NisServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NisServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.NisServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NisServiceResponseInlineRecords[i] != nil {
			if err := o.NisServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nis delete collection body based on the context it is used
func (o *NisDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNisServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisDeleteCollectionBody) contextValidateNisServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NisServiceResponseInlineRecords); i++ {

		if o.NisServiceResponseInlineRecords[i] != nil {
			if err := o.NisServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NisDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
