// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNisModifyCollectionParams creates a new NisModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNisModifyCollectionParams() *NisModifyCollectionParams {
	return &NisModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNisModifyCollectionParamsWithTimeout creates a new NisModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNisModifyCollectionParamsWithTimeout(timeout time.Duration) *NisModifyCollectionParams {
	return &NisModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNisModifyCollectionParamsWithContext creates a new NisModifyCollectionParams object
// with the ability to set a context for a request.
func NewNisModifyCollectionParamsWithContext(ctx context.Context) *NisModifyCollectionParams {
	return &NisModifyCollectionParams{
		Context: ctx,
	}
}

// NewNisModifyCollectionParamsWithHTTPClient creates a new NisModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNisModifyCollectionParamsWithHTTPClient(client *http.Client) *NisModifyCollectionParams {
	return &NisModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NisModifyCollectionParams contains all the parameters to send to the API endpoint

	for the nis modify collection operation.

	Typically these are written to a http.Request.
*/
type NisModifyCollectionParams struct {

	/* BindingDetailsServer.

	   Filter by binding_details.server
	*/
	BindingDetailsServer *string

	/* BindingDetailsStatusCode.

	   Filter by binding_details.status.code
	*/
	BindingDetailsStatusCode *string

	/* BindingDetailsStatusMessage.

	   Filter by binding_details.status.message
	*/
	BindingDetailsStatusMessage *string

	/* BoundServers.

	   Filter by bound_servers
	*/
	BoundServers *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Domain.

	   Filter by domain
	*/
	Domain *string

	/* Info.

	   Info specification
	*/
	Info NisModifyCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nis modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisModifyCollectionParams) WithDefaults() *NisModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nis modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NisModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nis modify collection params
func (o *NisModifyCollectionParams) WithTimeout(timeout time.Duration) *NisModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nis modify collection params
func (o *NisModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nis modify collection params
func (o *NisModifyCollectionParams) WithContext(ctx context.Context) *NisModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nis modify collection params
func (o *NisModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nis modify collection params
func (o *NisModifyCollectionParams) WithHTTPClient(client *http.Client) *NisModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nis modify collection params
func (o *NisModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBindingDetailsServer adds the bindingDetailsServer to the nis modify collection params
func (o *NisModifyCollectionParams) WithBindingDetailsServer(bindingDetailsServer *string) *NisModifyCollectionParams {
	o.SetBindingDetailsServer(bindingDetailsServer)
	return o
}

// SetBindingDetailsServer adds the bindingDetailsServer to the nis modify collection params
func (o *NisModifyCollectionParams) SetBindingDetailsServer(bindingDetailsServer *string) {
	o.BindingDetailsServer = bindingDetailsServer
}

// WithBindingDetailsStatusCode adds the bindingDetailsStatusCode to the nis modify collection params
func (o *NisModifyCollectionParams) WithBindingDetailsStatusCode(bindingDetailsStatusCode *string) *NisModifyCollectionParams {
	o.SetBindingDetailsStatusCode(bindingDetailsStatusCode)
	return o
}

// SetBindingDetailsStatusCode adds the bindingDetailsStatusCode to the nis modify collection params
func (o *NisModifyCollectionParams) SetBindingDetailsStatusCode(bindingDetailsStatusCode *string) {
	o.BindingDetailsStatusCode = bindingDetailsStatusCode
}

// WithBindingDetailsStatusMessage adds the bindingDetailsStatusMessage to the nis modify collection params
func (o *NisModifyCollectionParams) WithBindingDetailsStatusMessage(bindingDetailsStatusMessage *string) *NisModifyCollectionParams {
	o.SetBindingDetailsStatusMessage(bindingDetailsStatusMessage)
	return o
}

// SetBindingDetailsStatusMessage adds the bindingDetailsStatusMessage to the nis modify collection params
func (o *NisModifyCollectionParams) SetBindingDetailsStatusMessage(bindingDetailsStatusMessage *string) {
	o.BindingDetailsStatusMessage = bindingDetailsStatusMessage
}

// WithBoundServers adds the boundServers to the nis modify collection params
func (o *NisModifyCollectionParams) WithBoundServers(boundServers *string) *NisModifyCollectionParams {
	o.SetBoundServers(boundServers)
	return o
}

// SetBoundServers adds the boundServers to the nis modify collection params
func (o *NisModifyCollectionParams) SetBoundServers(boundServers *string) {
	o.BoundServers = boundServers
}

// WithContinueOnFailure adds the continueOnFailure to the nis modify collection params
func (o *NisModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NisModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the nis modify collection params
func (o *NisModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDomain adds the domain to the nis modify collection params
func (o *NisModifyCollectionParams) WithDomain(domain *string) *NisModifyCollectionParams {
	o.SetDomain(domain)
	return o
}

// SetDomain adds the domain to the nis modify collection params
func (o *NisModifyCollectionParams) SetDomain(domain *string) {
	o.Domain = domain
}

// WithInfo adds the info to the nis modify collection params
func (o *NisModifyCollectionParams) WithInfo(info NisModifyCollectionBody) *NisModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nis modify collection params
func (o *NisModifyCollectionParams) SetInfo(info NisModifyCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the nis modify collection params
func (o *NisModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NisModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nis modify collection params
func (o *NisModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nis modify collection params
func (o *NisModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NisModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nis modify collection params
func (o *NisModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the nis modify collection params
func (o *NisModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NisModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the nis modify collection params
func (o *NisModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServers adds the servers to the nis modify collection params
func (o *NisModifyCollectionParams) WithServers(servers *string) *NisModifyCollectionParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the nis modify collection params
func (o *NisModifyCollectionParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithSvmName adds the svmName to the nis modify collection params
func (o *NisModifyCollectionParams) WithSvmName(svmName *string) *NisModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nis modify collection params
func (o *NisModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nis modify collection params
func (o *NisModifyCollectionParams) WithSvmUUID(svmUUID *string) *NisModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nis modify collection params
func (o *NisModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NisModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BindingDetailsServer != nil {

		// query param binding_details.server
		var qrBindingDetailsServer string

		if o.BindingDetailsServer != nil {
			qrBindingDetailsServer = *o.BindingDetailsServer
		}
		qBindingDetailsServer := qrBindingDetailsServer
		if qBindingDetailsServer != "" {

			if err := r.SetQueryParam("binding_details.server", qBindingDetailsServer); err != nil {
				return err
			}
		}
	}

	if o.BindingDetailsStatusCode != nil {

		// query param binding_details.status.code
		var qrBindingDetailsStatusCode string

		if o.BindingDetailsStatusCode != nil {
			qrBindingDetailsStatusCode = *o.BindingDetailsStatusCode
		}
		qBindingDetailsStatusCode := qrBindingDetailsStatusCode
		if qBindingDetailsStatusCode != "" {

			if err := r.SetQueryParam("binding_details.status.code", qBindingDetailsStatusCode); err != nil {
				return err
			}
		}
	}

	if o.BindingDetailsStatusMessage != nil {

		// query param binding_details.status.message
		var qrBindingDetailsStatusMessage string

		if o.BindingDetailsStatusMessage != nil {
			qrBindingDetailsStatusMessage = *o.BindingDetailsStatusMessage
		}
		qBindingDetailsStatusMessage := qrBindingDetailsStatusMessage
		if qBindingDetailsStatusMessage != "" {

			if err := r.SetQueryParam("binding_details.status.message", qBindingDetailsStatusMessage); err != nil {
				return err
			}
		}
	}

	if o.BoundServers != nil {

		// query param bound_servers
		var qrBoundServers string

		if o.BoundServers != nil {
			qrBoundServers = *o.BoundServers
		}
		qBoundServers := qrBoundServers
		if qBoundServers != "" {

			if err := r.SetQueryParam("bound_servers", qBoundServers); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Domain != nil {

		// query param domain
		var qrDomain string

		if o.Domain != nil {
			qrDomain = *o.Domain
		}
		qDomain := qrDomain
		if qDomain != "" {

			if err := r.SetQueryParam("domain", qDomain); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
