// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NisModifyCollectionReader is a Reader for the NisModifyCollection structure.
type NisModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NisModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNisModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNisModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNisModifyCollectionOK creates a NisModifyCollectionOK with default headers values
func NewNisModifyCollectionOK() *NisModifyCollectionOK {
	return &NisModifyCollectionOK{}
}

/*
NisModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NisModifyCollectionOK struct {
}

// IsSuccess returns true when this nis modify collection o k response has a 2xx status code
func (o *NisModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nis modify collection o k response has a 3xx status code
func (o *NisModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nis modify collection o k response has a 4xx status code
func (o *NisModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nis modify collection o k response has a 5xx status code
func (o *NisModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nis modify collection o k response a status code equal to that given
func (o *NisModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nis modify collection o k response
func (o *NisModifyCollectionOK) Code() int {
	return 200
}

func (o *NisModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/nis][%d] nisModifyCollectionOK", 200)
}

func (o *NisModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/nis][%d] nisModifyCollectionOK", 200)
}

func (o *NisModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNisModifyCollectionDefault creates a NisModifyCollectionDefault with default headers values
func NewNisModifyCollectionDefault(code int) *NisModifyCollectionDefault {
	return &NisModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NisModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966253    | IPv6 is not enabled in the cluster |
| 2621488    | Invalid SVM context |
| 2621706    | The specified SVM UUID is incorrect for the specified SVM name |
| 3276964    | NIS domain name or NIS server domain is too long. The maximum supported for domain name is 64 characters and the maximum supported for NIS server domain is 255 characters |
| 3276933    | A maximum of 10 NIS servers can be configured per SVM |
| 23724109   | DNS resolution failed for one or more specified servers  |
| 23724111   | Empty NIS servers cannot be specified.  |
| 23724112   | DNS resolution failed due to an internal error. Contact technical support if this issue persists |
| 23724132   | DNS resolution failed for all the specified servers  |
| 23724130   | Cannot use an IPv6 name server address because there are no IPv6 LIFs |
*/
type NisModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nis modify collection default response has a 2xx status code
func (o *NisModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nis modify collection default response has a 3xx status code
func (o *NisModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nis modify collection default response has a 4xx status code
func (o *NisModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nis modify collection default response has a 5xx status code
func (o *NisModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nis modify collection default response a status code equal to that given
func (o *NisModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nis modify collection default response
func (o *NisModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NisModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/nis][%d] nis_modify_collection default %s", o._statusCode, payload)
}

func (o *NisModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/nis][%d] nis_modify_collection default %s", o._statusCode, payload)
}

func (o *NisModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NisModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NisModifyCollectionBody nis modify collection body
swagger:model NisModifyCollectionBody
*/
type NisModifyCollectionBody struct {

	// links
	Links *models.NisServiceInlineLinks `json:"_links,omitempty"`

	// The NIS domain to which this configuration belongs.
	//
	// Example: domainA.example.com
	// Max Length: 64
	// Min Length: 1
	Domain *string `json:"domain,omitempty"`

	// An array of objects where each object represents the NIS server and it's status for a given NIS domain. It is an advanced field.
	// Read Only: true
	NisServiceInlineBindingDetails []*models.NisServiceInlineBindingDetailsInlineArrayItem `json:"binding_details,omitempty"`

	// nis service inline bound servers
	// Read Only: true
	NisServiceInlineBoundServers []*string `json:"bound_servers,omitempty"`

	// A list of hostnames or IP addresses of NIS servers used
	// by the NIS domain configuration.
	//
	// Example: ["10.10.10.10","example.com"]
	// Max Items: 10
	NisServiceInlineServers []*string `json:"servers,omitempty"`

	// nis service response inline records
	NisServiceResponseInlineRecords []*models.NisService `json:"records,omitempty"`

	// svm
	Svm *models.NisServiceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this nis modify collection body
func (o *NisModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNisServiceInlineBindingDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNisServiceInlineBoundServers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNisServiceInlineServers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNisServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NisModifyCollectionBody) validateDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.Domain) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"domain", "body", *o.Domain, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"domain", "body", *o.Domain, 64); err != nil {
		return err
	}

	return nil
}

func (o *NisModifyCollectionBody) validateNisServiceInlineBindingDetails(formats strfmt.Registry) error {
	if swag.IsZero(o.NisServiceInlineBindingDetails) { // not required
		return nil
	}

	for i := 0; i < len(o.NisServiceInlineBindingDetails); i++ {
		if swag.IsZero(o.NisServiceInlineBindingDetails[i]) { // not required
			continue
		}

		if o.NisServiceInlineBindingDetails[i] != nil {
			if err := o.NisServiceInlineBindingDetails[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) validateNisServiceInlineBoundServers(formats strfmt.Registry) error {
	if swag.IsZero(o.NisServiceInlineBoundServers) { // not required
		return nil
	}

	for i := 0; i < len(o.NisServiceInlineBoundServers); i++ {
		if swag.IsZero(o.NisServiceInlineBoundServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("info"+"."+"bound_servers"+"."+strconv.Itoa(i), "body", *o.NisServiceInlineBoundServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("info"+"."+"bound_servers"+"."+strconv.Itoa(i), "body", *o.NisServiceInlineBoundServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) validateNisServiceInlineServers(formats strfmt.Registry) error {
	if swag.IsZero(o.NisServiceInlineServers) { // not required
		return nil
	}

	iNisServiceInlineServersSize := int64(len(o.NisServiceInlineServers))

	if err := validate.MaxItems("info"+"."+"servers", "body", iNisServiceInlineServersSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(o.NisServiceInlineServers); i++ {
		if swag.IsZero(o.NisServiceInlineServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("info"+"."+"servers"+"."+strconv.Itoa(i), "body", *o.NisServiceInlineServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("info"+"."+"servers"+"."+strconv.Itoa(i), "body", *o.NisServiceInlineServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) validateNisServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NisServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NisServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.NisServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NisServiceResponseInlineRecords[i] != nil {
			if err := o.NisServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis modify collection body based on the context it is used
func (o *NisModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNisServiceInlineBindingDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNisServiceInlineBoundServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNisServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NisModifyCollectionBody) contextValidateNisServiceInlineBindingDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"binding_details", "body", []*models.NisServiceInlineBindingDetailsInlineArrayItem(o.NisServiceInlineBindingDetails)); err != nil {
		return err
	}

	for i := 0; i < len(o.NisServiceInlineBindingDetails); i++ {

		if o.NisServiceInlineBindingDetails[i] != nil {
			if err := o.NisServiceInlineBindingDetails[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) contextValidateNisServiceInlineBoundServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"bound_servers", "body", []*string(o.NisServiceInlineBoundServers)); err != nil {
		return err
	}

	return nil
}

func (o *NisModifyCollectionBody) contextValidateNisServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NisServiceResponseInlineRecords); i++ {

		if o.NisServiceResponseInlineRecords[i] != nil {
			if err := o.NisServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NisModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NisModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NisServiceInlineLinks nis service inline links
swagger:model nis_service_inline__links
*/
type NisServiceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nis service inline links
func (o *NisServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline links based on the context it is used
func (o *NisServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NisServiceInlineBindingDetailsInlineArrayItem nis service inline binding details inline array item
swagger:model nis_service_inline_binding_details_inline_array_item
*/
type NisServiceInlineBindingDetailsInlineArrayItem struct {

	// Hostname/IP address of the NIS server in the domain.
	// Max Length: 255
	// Min Length: 1
	Server *string `json:"server,omitempty"`

	// status
	Status *models.BindingStatus `json:"status,omitempty"`
}

// Validate validates this nis service inline binding details inline array item
func (o *NisServiceInlineBindingDetailsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineBindingDetailsInlineArrayItem) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(o.Server) { // not required
		return nil
	}

	if err := validate.MinLength("server", "body", *o.Server, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("server", "body", *o.Server, 255); err != nil {
		return err
	}

	return nil
}

func (o *NisServiceInlineBindingDetailsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline binding details inline array item based on the context it is used
func (o *NisServiceInlineBindingDetailsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineBindingDetailsInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisServiceInlineBindingDetailsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisServiceInlineBindingDetailsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineBindingDetailsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NisServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model nis_service_inline_svm
*/
type NisServiceInlineSvm struct {

	// links
	Links *models.NisServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nis service inline svm
func (o *NisServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline svm based on the context it is used
func (o *NisServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NisServiceInlineSvmInlineLinks nis service inline svm inline links
swagger:model nis_service_inline_svm_inline__links
*/
type NisServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nis service inline svm inline links
func (o *NisServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline svm inline links based on the context it is used
func (o *NisServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NisServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NisServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NisServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
