// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNisModifyParams creates a new NisModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNisModifyParams() *NisModifyParams {
	return &NisModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNisModifyParamsWithTimeout creates a new NisModifyParams object
// with the ability to set a timeout on a request.
func NewNisModifyParamsWithTimeout(timeout time.Duration) *NisModifyParams {
	return &NisModifyParams{
		timeout: timeout,
	}
}

// NewNisModifyParamsWithContext creates a new NisModifyParams object
// with the ability to set a context for a request.
func NewNisModifyParamsWithContext(ctx context.Context) *NisModifyParams {
	return &NisModifyParams{
		Context: ctx,
	}
}

// NewNisModifyParamsWithHTTPClient creates a new NisModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewNisModifyParamsWithHTTPClient(client *http.Client) *NisModifyParams {
	return &NisModifyParams{
		HTTPClient: client,
	}
}

/*
NisModifyParams contains all the parameters to send to the API endpoint

	for the nis modify operation.

	Typically these are written to a http.Request.
*/
type NisModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.NisService

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nis modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisModifyParams) WithDefaults() *NisModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nis modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NisModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the nis modify params
func (o *NisModifyParams) WithTimeout(timeout time.Duration) *NisModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nis modify params
func (o *NisModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nis modify params
func (o *NisModifyParams) WithContext(ctx context.Context) *NisModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nis modify params
func (o *NisModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nis modify params
func (o *NisModifyParams) WithHTTPClient(client *http.Client) *NisModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nis modify params
func (o *NisModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the nis modify params
func (o *NisModifyParams) WithInfo(info *models.NisService) *NisModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nis modify params
func (o *NisModifyParams) SetInfo(info *models.NisService) {
	o.Info = info
}

// WithSvmUUID adds the svmUUID to the nis modify params
func (o *NisModifyParams) WithSvmUUID(svmUUID string) *NisModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nis modify params
func (o *NisModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NisModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
