// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupDeleteCollectionReader is a Reader for the UnixGroupDeleteCollection structure.
type UnixGroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixGroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupDeleteCollectionOK creates a UnixGroupDeleteCollectionOK with default headers values
func NewUnixGroupDeleteCollectionOK() *UnixGroupDeleteCollectionOK {
	return &UnixGroupDeleteCollectionOK{}
}

/*
UnixGroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type UnixGroupDeleteCollectionOK struct {
}

// IsSuccess returns true when this unix group delete collection o k response has a 2xx status code
func (o *UnixGroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group delete collection o k response has a 3xx status code
func (o *UnixGroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group delete collection o k response has a 4xx status code
func (o *UnixGroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group delete collection o k response has a 5xx status code
func (o *UnixGroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group delete collection o k response a status code equal to that given
func (o *UnixGroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix group delete collection o k response
func (o *UnixGroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *UnixGroupDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups][%d] unixGroupDeleteCollectionOK", 200)
}

func (o *UnixGroupDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups][%d] unixGroupDeleteCollectionOK", 200)
}

func (o *UnixGroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixGroupDeleteCollectionDefault creates a UnixGroupDeleteCollectionDefault with default headers values
func NewUnixGroupDeleteCollectionDefault(code int) *UnixGroupDeleteCollectionDefault {
	return &UnixGroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
UnixGroupDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type UnixGroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group delete collection default response has a 2xx status code
func (o *UnixGroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group delete collection default response has a 3xx status code
func (o *UnixGroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group delete collection default response has a 4xx status code
func (o *UnixGroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group delete collection default response has a 5xx status code
func (o *UnixGroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group delete collection default response a status code equal to that given
func (o *UnixGroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group delete collection default response
func (o *UnixGroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups][%d] unix_group_delete_collection default %s", o._statusCode, payload)
}

func (o *UnixGroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups][%d] unix_group_delete_collection default %s", o._statusCode, payload)
}

func (o *UnixGroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UnixGroupDeleteCollectionBody unix group delete collection body
swagger:model UnixGroupDeleteCollectionBody
*/
type UnixGroupDeleteCollectionBody struct {

	// Number of UNIX groups and members.
	CurrentCount *int64 `json:"current_count,omitempty"`

	// unix group response inline records
	UnixGroupResponseInlineRecords []*models.UnixGroup `json:"records,omitempty"`
}

// Validate validates this unix group delete collection body
func (o *UnixGroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUnixGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupDeleteCollectionBody) validateUnixGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.UnixGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.UnixGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.UnixGroupResponseInlineRecords[i] != nil {
			if err := o.UnixGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this unix group delete collection body based on the context it is used
func (o *UnixGroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUnixGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupDeleteCollectionBody) contextValidateUnixGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.UnixGroupResponseInlineRecords); i++ {

		if o.UnixGroupResponseInlineRecords[i] != nil {
			if err := o.UnixGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixGroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixGroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res UnixGroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
