// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupDeleteReader is a Reader for the UnixGroupDelete structure.
type UnixGroupDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixGroupDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupDeleteOK creates a UnixGroupDeleteOK with default headers values
func NewUnixGroupDeleteOK() *UnixGroupDeleteOK {
	return &UnixGroupDeleteOK{}
}

/*
UnixGroupDeleteOK describes a response with status code 200, with default header values.

OK
*/
type UnixGroupDeleteOK struct {
}

// IsSuccess returns true when this unix group delete o k response has a 2xx status code
func (o *UnixGroupDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group delete o k response has a 3xx status code
func (o *UnixGroupDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group delete o k response has a 4xx status code
func (o *UnixGroupDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group delete o k response has a 5xx status code
func (o *UnixGroupDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group delete o k response a status code equal to that given
func (o *UnixGroupDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix group delete o k response
func (o *UnixGroupDeleteOK) Code() int {
	return 200
}

func (o *UnixGroupDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{name}][%d] unixGroupDeleteOK", 200)
}

func (o *UnixGroupDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{name}][%d] unixGroupDeleteOK", 200)
}

func (o *UnixGroupDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixGroupDeleteDefault creates a UnixGroupDeleteDefault with default headers values
func NewUnixGroupDeleteDefault(code int) *UnixGroupDeleteDefault {
	return &UnixGroupDeleteDefault{
		_statusCode: code,
	}
}

/*
UnixGroupDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type UnixGroupDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group delete default response has a 2xx status code
func (o *UnixGroupDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group delete default response has a 3xx status code
func (o *UnixGroupDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group delete default response has a 4xx status code
func (o *UnixGroupDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group delete default response has a 5xx status code
func (o *UnixGroupDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group delete default response a status code equal to that given
func (o *UnixGroupDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group delete default response
func (o *UnixGroupDeleteDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{name}][%d] unix_group_delete default %s", o._statusCode, payload)
}

func (o *UnixGroupDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{name}][%d] unix_group_delete default %s", o._statusCode, payload)
}

func (o *UnixGroupDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
