// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixGroupGetParams creates a new UnixGroupGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixGroupGetParams() *UnixGroupGetParams {
	return &UnixGroupGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixGroupGetParamsWithTimeout creates a new UnixGroupGetParams object
// with the ability to set a timeout on a request.
func NewUnixGroupGetParamsWithTimeout(timeout time.Duration) *UnixGroupGetParams {
	return &UnixGroupGetParams{
		timeout: timeout,
	}
}

// NewUnixGroupGetParamsWithContext creates a new UnixGroupGetParams object
// with the ability to set a context for a request.
func NewUnixGroupGetParamsWithContext(ctx context.Context) *UnixGroupGetParams {
	return &UnixGroupGetParams{
		Context: ctx,
	}
}

// NewUnixGroupGetParamsWithHTTPClient creates a new UnixGroupGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixGroupGetParamsWithHTTPClient(client *http.Client) *UnixGroupGetParams {
	return &UnixGroupGetParams{
		HTTPClient: client,
	}
}

/*
UnixGroupGetParams contains all the parameters to send to the API endpoint

	for the unix group get operation.

	Typically these are written to a http.Request.
*/
type UnixGroupGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   UNIX group name.
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupGetParams) WithDefaults() *UnixGroupGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unix group get params
func (o *UnixGroupGetParams) WithTimeout(timeout time.Duration) *UnixGroupGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix group get params
func (o *UnixGroupGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix group get params
func (o *UnixGroupGetParams) WithContext(ctx context.Context) *UnixGroupGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix group get params
func (o *UnixGroupGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix group get params
func (o *UnixGroupGetParams) WithHTTPClient(client *http.Client) *UnixGroupGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix group get params
func (o *UnixGroupGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the unix group get params
func (o *UnixGroupGetParams) WithFields(fields []string) *UnixGroupGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the unix group get params
func (o *UnixGroupGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the unix group get params
func (o *UnixGroupGetParams) WithName(name string) *UnixGroupGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix group get params
func (o *UnixGroupGetParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the unix group get params
func (o *UnixGroupGetParams) WithSvmUUID(svmUUID string) *UnixGroupGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix group get params
func (o *UnixGroupGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixGroupGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamUnixGroupGet binds the parameter fields
func (o *UnixGroupGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
