// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixGroupModifyCollectionParams creates a new UnixGroupModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixGroupModifyCollectionParams() *UnixGroupModifyCollectionParams {
	return &UnixGroupModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixGroupModifyCollectionParamsWithTimeout creates a new UnixGroupModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewUnixGroupModifyCollectionParamsWithTimeout(timeout time.Duration) *UnixGroupModifyCollectionParams {
	return &UnixGroupModifyCollectionParams{
		timeout: timeout,
	}
}

// NewUnixGroupModifyCollectionParamsWithContext creates a new UnixGroupModifyCollectionParams object
// with the ability to set a context for a request.
func NewUnixGroupModifyCollectionParamsWithContext(ctx context.Context) *UnixGroupModifyCollectionParams {
	return &UnixGroupModifyCollectionParams{
		Context: ctx,
	}
}

// NewUnixGroupModifyCollectionParamsWithHTTPClient creates a new UnixGroupModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixGroupModifyCollectionParamsWithHTTPClient(client *http.Client) *UnixGroupModifyCollectionParams {
	return &UnixGroupModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
UnixGroupModifyCollectionParams contains all the parameters to send to the API endpoint

	for the unix group modify collection operation.

	Typically these are written to a http.Request.
*/
type UnixGroupModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info UnixGroupModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix group modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupModifyCollectionParams) WithDefaults() *UnixGroupModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix group modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := UnixGroupModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithTimeout(timeout time.Duration) *UnixGroupModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithContext(ctx context.Context) *UnixGroupModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithHTTPClient(client *http.Client) *UnixGroupModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *UnixGroupModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithID adds the id to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithID(id *int64) *UnixGroupModifyCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithInfo(info UnixGroupModifyCollectionBody) *UnixGroupModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetInfo(info UnixGroupModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithName(name *string) *UnixGroupModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithReturnRecords(returnRecords *bool) *UnixGroupModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *UnixGroupModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithSerialRecords(serialRecords *bool) *UnixGroupModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithSvmName(svmName *string) *UnixGroupModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithSvmUUID(svmUUID *string) *UnixGroupModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUsersName adds the usersName to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) WithUsersName(usersName *string) *UnixGroupModifyCollectionParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the unix group modify collection params
func (o *UnixGroupModifyCollectionParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WriteToRequest writes these params to a swagger request
func (o *UnixGroupModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
