// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewUnixGroupModifyParams creates a new UnixGroupModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixGroupModifyParams() *UnixGroupModifyParams {
	return &UnixGroupModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixGroupModifyParamsWithTimeout creates a new UnixGroupModifyParams object
// with the ability to set a timeout on a request.
func NewUnixGroupModifyParamsWithTimeout(timeout time.Duration) *UnixGroupModifyParams {
	return &UnixGroupModifyParams{
		timeout: timeout,
	}
}

// NewUnixGroupModifyParamsWithContext creates a new UnixGroupModifyParams object
// with the ability to set a context for a request.
func NewUnixGroupModifyParamsWithContext(ctx context.Context) *UnixGroupModifyParams {
	return &UnixGroupModifyParams{
		Context: ctx,
	}
}

// NewUnixGroupModifyParamsWithHTTPClient creates a new UnixGroupModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixGroupModifyParamsWithHTTPClient(client *http.Client) *UnixGroupModifyParams {
	return &UnixGroupModifyParams{
		HTTPClient: client,
	}
}

/*
UnixGroupModifyParams contains all the parameters to send to the API endpoint

	for the unix group modify operation.

	Typically these are written to a http.Request.
*/
type UnixGroupModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.UnixGroup

	/* Name.

	   UNIX group name.
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix group modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupModifyParams) WithDefaults() *UnixGroupModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix group modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unix group modify params
func (o *UnixGroupModifyParams) WithTimeout(timeout time.Duration) *UnixGroupModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix group modify params
func (o *UnixGroupModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix group modify params
func (o *UnixGroupModifyParams) WithContext(ctx context.Context) *UnixGroupModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix group modify params
func (o *UnixGroupModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix group modify params
func (o *UnixGroupModifyParams) WithHTTPClient(client *http.Client) *UnixGroupModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix group modify params
func (o *UnixGroupModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the unix group modify params
func (o *UnixGroupModifyParams) WithInfo(info *models.UnixGroup) *UnixGroupModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix group modify params
func (o *UnixGroupModifyParams) SetInfo(info *models.UnixGroup) {
	o.Info = info
}

// WithName adds the name to the unix group modify params
func (o *UnixGroupModifyParams) WithName(name string) *UnixGroupModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix group modify params
func (o *UnixGroupModifyParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the unix group modify params
func (o *UnixGroupModifyParams) WithSvmUUID(svmUUID string) *UnixGroupModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix group modify params
func (o *UnixGroupModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixGroupModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
