// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupSettingsGetReader is a Reader for the UnixGroupSettingsGet structure.
type UnixGroupSettingsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupSettingsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixGroupSettingsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupSettingsGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupSettingsGetOK creates a UnixGroupSettingsGetOK with default headers values
func NewUnixGroupSettingsGetOK() *UnixGroupSettingsGetOK {
	return &UnixGroupSettingsGetOK{}
}

/*
UnixGroupSettingsGetOK describes a response with status code 200, with default header values.

OK
*/
type UnixGroupSettingsGetOK struct {
	Payload *models.UnixGroupSettings
}

// IsSuccess returns true when this unix group settings get o k response has a 2xx status code
func (o *UnixGroupSettingsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group settings get o k response has a 3xx status code
func (o *UnixGroupSettingsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group settings get o k response has a 4xx status code
func (o *UnixGroupSettingsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group settings get o k response has a 5xx status code
func (o *UnixGroupSettingsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group settings get o k response a status code equal to that given
func (o *UnixGroupSettingsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix group settings get o k response
func (o *UnixGroupSettingsGetOK) Code() int {
	return 200
}

func (o *UnixGroupSettingsGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-group/settings/{svm.uuid}][%d] unixGroupSettingsGetOK %s", 200, payload)
}

func (o *UnixGroupSettingsGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-group/settings/{svm.uuid}][%d] unixGroupSettingsGetOK %s", 200, payload)
}

func (o *UnixGroupSettingsGetOK) GetPayload() *models.UnixGroupSettings {
	return o.Payload
}

func (o *UnixGroupSettingsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UnixGroupSettings)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnixGroupSettingsGetDefault creates a UnixGroupSettingsGetDefault with default headers values
func NewUnixGroupSettingsGetDefault(code int) *UnixGroupSettingsGetDefault {
	return &UnixGroupSettingsGetDefault{
		_statusCode: code,
	}
}

/*
UnixGroupSettingsGetDefault describes a response with status code -1, with default header values.

Error
*/
type UnixGroupSettingsGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group settings get default response has a 2xx status code
func (o *UnixGroupSettingsGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group settings get default response has a 3xx status code
func (o *UnixGroupSettingsGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group settings get default response has a 4xx status code
func (o *UnixGroupSettingsGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group settings get default response has a 5xx status code
func (o *UnixGroupSettingsGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group settings get default response a status code equal to that given
func (o *UnixGroupSettingsGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group settings get default response
func (o *UnixGroupSettingsGetDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupSettingsGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-group/settings/{svm.uuid}][%d] unix_group_settings_get default %s", o._statusCode, payload)
}

func (o *UnixGroupSettingsGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-group/settings/{svm.uuid}][%d] unix_group_settings_get default %s", o._statusCode, payload)
}

func (o *UnixGroupSettingsGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupSettingsGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
