// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupSettingsModifyCollectionReader is a Reader for the UnixGroupSettingsModifyCollection structure.
type UnixGroupSettingsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupSettingsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixGroupSettingsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupSettingsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupSettingsModifyCollectionOK creates a UnixGroupSettingsModifyCollectionOK with default headers values
func NewUnixGroupSettingsModifyCollectionOK() *UnixGroupSettingsModifyCollectionOK {
	return &UnixGroupSettingsModifyCollectionOK{}
}

/*
UnixGroupSettingsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type UnixGroupSettingsModifyCollectionOK struct {
}

// IsSuccess returns true when this unix group settings modify collection o k response has a 2xx status code
func (o *UnixGroupSettingsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group settings modify collection o k response has a 3xx status code
func (o *UnixGroupSettingsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group settings modify collection o k response has a 4xx status code
func (o *UnixGroupSettingsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group settings modify collection o k response has a 5xx status code
func (o *UnixGroupSettingsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group settings modify collection o k response a status code equal to that given
func (o *UnixGroupSettingsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix group settings modify collection o k response
func (o *UnixGroupSettingsModifyCollectionOK) Code() int {
	return 200
}

func (o *UnixGroupSettingsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/unix-group/settings][%d] unixGroupSettingsModifyCollectionOK", 200)
}

func (o *UnixGroupSettingsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/unix-group/settings][%d] unixGroupSettingsModifyCollectionOK", 200)
}

func (o *UnixGroupSettingsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixGroupSettingsModifyCollectionDefault creates a UnixGroupSettingsModifyCollectionDefault with default headers values
func NewUnixGroupSettingsModifyCollectionDefault(code int) *UnixGroupSettingsModifyCollectionDefault {
	return &UnixGroupSettingsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	UnixGroupSettingsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type UnixGroupSettingsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group settings modify collection default response has a 2xx status code
func (o *UnixGroupSettingsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group settings modify collection default response has a 3xx status code
func (o *UnixGroupSettingsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group settings modify collection default response has a 4xx status code
func (o *UnixGroupSettingsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group settings modify collection default response has a 5xx status code
func (o *UnixGroupSettingsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group settings modify collection default response a status code equal to that given
func (o *UnixGroupSettingsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group settings modify collection default response
func (o *UnixGroupSettingsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupSettingsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/unix-group/settings][%d] unix_group_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *UnixGroupSettingsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/unix-group/settings][%d] unix_group_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *UnixGroupSettingsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupSettingsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UnixGroupSettingsModifyCollectionBody unix group settings modify collection body
swagger:model UnixGroupSettingsModifyCollectionBody
*/
type UnixGroupSettingsModifyCollectionBody struct {

	// links
	Links *models.UnixGroupSettingsInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not the cache is enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// Indicates whether or not the negative cache is enabled.
	//
	NegativeCacheEnabled *bool `json:"negative_cache_enabled,omitempty"`

	// Specifies negative Time to Live, in ISO 8601 format.
	//
	// Example: PT5M
	NegativeTTL *string `json:"negative_ttl,omitempty"`

	// Specifies whether the propagation setting is enabled or not.
	//
	PropagationEnabled *bool `json:"propagation_enabled,omitempty"`

	// svm
	Svm *models.UnixGroupSettingsInlineSvm `json:"svm,omitempty"`

	// Specifies Time to Live (TTL), in ISO 8601 format.
	//
	// Example: PT24H
	TTL *string `json:"ttl,omitempty"`

	// unix group settings response inline records
	UnixGroupSettingsResponseInlineRecords []*models.UnixGroupSettings `json:"records,omitempty"`
}

// Validate validates this unix group settings modify collection body
func (o *UnixGroupSettingsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnixGroupSettingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) validateUnixGroupSettingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixGroupSettingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.UnixGroupSettingsResponseInlineRecords); i++ {
		if swag.IsZero(o.UnixGroupSettingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.UnixGroupSettingsResponseInlineRecords[i] != nil {
			if err := o.UnixGroupSettingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this unix group settings modify collection body based on the context it is used
func (o *UnixGroupSettingsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnixGroupSettingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *UnixGroupSettingsModifyCollectionBody) contextValidateUnixGroupSettingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.UnixGroupSettingsResponseInlineRecords); i++ {

		if o.UnixGroupSettingsResponseInlineRecords[i] != nil {
			if err := o.UnixGroupSettingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixGroupSettingsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixGroupSettingsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res UnixGroupSettingsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixGroupSettingsInlineLinks unix group settings inline links
swagger:model unix_group_settings_inline__links
*/
type UnixGroupSettingsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this unix group settings inline links
func (o *UnixGroupSettingsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group settings inline links based on the context it is used
func (o *UnixGroupSettingsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixGroupSettingsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixGroupSettingsInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixGroupSettingsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixGroupSettingsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model unix_group_settings_inline_svm
*/
type UnixGroupSettingsInlineSvm struct {

	// links
	Links *models.UnixGroupSettingsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this unix group settings inline svm
func (o *UnixGroupSettingsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group settings inline svm based on the context it is used
func (o *UnixGroupSettingsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixGroupSettingsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixGroupSettingsInlineSvm) UnmarshalBinary(b []byte) error {
	var res UnixGroupSettingsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixGroupSettingsInlineSvmInlineLinks unix group settings inline svm inline links
swagger:model unix_group_settings_inline_svm_inline__links
*/
type UnixGroupSettingsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this unix group settings inline svm inline links
func (o *UnixGroupSettingsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix group settings inline svm inline links based on the context it is used
func (o *UnixGroupSettingsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixGroupSettingsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixGroupSettingsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixGroupSettingsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixGroupSettingsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
