// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUnixGroupUserDeleteParams creates a new UnixGroupUserDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixGroupUserDeleteParams() *UnixGroupUserDeleteParams {
	return &UnixGroupUserDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixGroupUserDeleteParamsWithTimeout creates a new UnixGroupUserDeleteParams object
// with the ability to set a timeout on a request.
func NewUnixGroupUserDeleteParamsWithTimeout(timeout time.Duration) *UnixGroupUserDeleteParams {
	return &UnixGroupUserDeleteParams{
		timeout: timeout,
	}
}

// NewUnixGroupUserDeleteParamsWithContext creates a new UnixGroupUserDeleteParams object
// with the ability to set a context for a request.
func NewUnixGroupUserDeleteParamsWithContext(ctx context.Context) *UnixGroupUserDeleteParams {
	return &UnixGroupUserDeleteParams{
		Context: ctx,
	}
}

// NewUnixGroupUserDeleteParamsWithHTTPClient creates a new UnixGroupUserDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixGroupUserDeleteParamsWithHTTPClient(client *http.Client) *UnixGroupUserDeleteParams {
	return &UnixGroupUserDeleteParams{
		HTTPClient: client,
	}
}

/*
UnixGroupUserDeleteParams contains all the parameters to send to the API endpoint

	for the unix group user delete operation.

	Typically these are written to a http.Request.
*/
type UnixGroupUserDeleteParams struct {

	/* Name.

	   UNIX user to be deleted from the group.
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UnixGroupName.

	   UNIX group name.
	*/
	UnixGroupName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix group user delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupUserDeleteParams) WithDefaults() *UnixGroupUserDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix group user delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixGroupUserDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithTimeout(timeout time.Duration) *UnixGroupUserDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithContext(ctx context.Context) *UnixGroupUserDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithHTTPClient(client *http.Client) *UnixGroupUserDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithName(name string) *UnixGroupUserDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithSvmUUID(svmUUID string) *UnixGroupUserDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUnixGroupName adds the unixGroupName to the unix group user delete params
func (o *UnixGroupUserDeleteParams) WithUnixGroupName(unixGroupName string) *UnixGroupUserDeleteParams {
	o.SetUnixGroupName(unixGroupName)
	return o
}

// SetUnixGroupName adds the unixGroupName to the unix group user delete params
func (o *UnixGroupUserDeleteParams) SetUnixGroupName(unixGroupName string) {
	o.UnixGroupName = unixGroupName
}

// WriteToRequest writes these params to a swagger request
func (o *UnixGroupUserDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param unix_group.name
	if err := r.SetPathParam("unix_group.name", o.UnixGroupName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
