// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupUserDeleteReader is a Reader for the UnixGroupUserDelete structure.
type UnixGroupUserDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupUserDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixGroupUserDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupUserDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupUserDeleteOK creates a UnixGroupUserDeleteOK with default headers values
func NewUnixGroupUserDeleteOK() *UnixGroupUserDeleteOK {
	return &UnixGroupUserDeleteOK{}
}

/*
UnixGroupUserDeleteOK describes a response with status code 200, with default header values.

OK
*/
type UnixGroupUserDeleteOK struct {
}

// IsSuccess returns true when this unix group user delete o k response has a 2xx status code
func (o *UnixGroupUserDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group user delete o k response has a 3xx status code
func (o *UnixGroupUserDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group user delete o k response has a 4xx status code
func (o *UnixGroupUserDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group user delete o k response has a 5xx status code
func (o *UnixGroupUserDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group user delete o k response a status code equal to that given
func (o *UnixGroupUserDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix group user delete o k response
func (o *UnixGroupUserDeleteOK) Code() int {
	return 200
}

func (o *UnixGroupUserDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}][%d] unixGroupUserDeleteOK", 200)
}

func (o *UnixGroupUserDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}][%d] unixGroupUserDeleteOK", 200)
}

func (o *UnixGroupUserDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixGroupUserDeleteDefault creates a UnixGroupUserDeleteDefault with default headers values
func NewUnixGroupUserDeleteDefault(code int) *UnixGroupUserDeleteDefault {
	return &UnixGroupUserDeleteDefault{
		_statusCode: code,
	}
}

/*
	UnixGroupUserDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3276897    | The specified UNIX group does not exist in the SVM. |
*/
type UnixGroupUserDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group user delete default response has a 2xx status code
func (o *UnixGroupUserDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group user delete default response has a 3xx status code
func (o *UnixGroupUserDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group user delete default response has a 4xx status code
func (o *UnixGroupUserDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group user delete default response has a 5xx status code
func (o *UnixGroupUserDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group user delete default response a status code equal to that given
func (o *UnixGroupUserDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group user delete default response
func (o *UnixGroupUserDeleteDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupUserDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}][%d] unix_group_user_delete default %s", o._statusCode, payload)
}

func (o *UnixGroupUserDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users/{name}][%d] unix_group_user_delete default %s", o._statusCode, payload)
}

func (o *UnixGroupUserDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupUserDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
