// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixGroupUsersCreateReader is a Reader for the UnixGroupUsersCreate structure.
type UnixGroupUsersCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixGroupUsersCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewUnixGroupUsersCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixGroupUsersCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixGroupUsersCreateCreated creates a UnixGroupUsersCreateCreated with default headers values
func NewUnixGroupUsersCreateCreated() *UnixGroupUsersCreateCreated {
	return &UnixGroupUsersCreateCreated{}
}

/*
UnixGroupUsersCreateCreated describes a response with status code 201, with default header values.

Created
*/
type UnixGroupUsersCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this unix group users create created response has a 2xx status code
func (o *UnixGroupUsersCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix group users create created response has a 3xx status code
func (o *UnixGroupUsersCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix group users create created response has a 4xx status code
func (o *UnixGroupUsersCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix group users create created response has a 5xx status code
func (o *UnixGroupUsersCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this unix group users create created response a status code equal to that given
func (o *UnixGroupUsersCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the unix group users create created response
func (o *UnixGroupUsersCreateCreated) Code() int {
	return 201
}

func (o *UnixGroupUsersCreateCreated) Error() string {
	return fmt.Sprintf("[POST /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users][%d] unixGroupUsersCreateCreated", 201)
}

func (o *UnixGroupUsersCreateCreated) String() string {
	return fmt.Sprintf("[POST /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users][%d] unixGroupUsersCreateCreated", 201)
}

func (o *UnixGroupUsersCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewUnixGroupUsersCreateDefault creates a UnixGroupUsersCreateDefault with default headers values
func NewUnixGroupUsersCreateDefault(code int) *UnixGroupUsersCreateDefault {
	return &UnixGroupUsersCreateDefault{
		_statusCode: code,
	}
}

/*
	UnixGroupUsersCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262179     | Invalid arguments in records. |
| 3276897    | The specified UNIX group does not exist in the SVM. |
| 3277025    | Maximum supported limit of UNIX group membership count reached. |
| 3277051    | Invalid characters in user name. Valid characters are 0-9, A-Z, a-z, ".", "_" and "-". Names cannot start with "-". |
| 23724066   | User name too long. Maximum supported length is 64 characters.|
| 23724142   | "records" field must not be specified when a single user is added.|
| 23724143   | SVM UUID, UNIX group name and skip-name-validation are invalid fields for "records" parameter. |
*/
type UnixGroupUsersCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix group users create default response has a 2xx status code
func (o *UnixGroupUsersCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix group users create default response has a 3xx status code
func (o *UnixGroupUsersCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix group users create default response has a 4xx status code
func (o *UnixGroupUsersCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix group users create default response has a 5xx status code
func (o *UnixGroupUsersCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix group users create default response a status code equal to that given
func (o *UnixGroupUsersCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix group users create default response
func (o *UnixGroupUsersCreateDefault) Code() int {
	return o._statusCode
}

func (o *UnixGroupUsersCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users][%d] unix_group_users_create default %s", o._statusCode, payload)
}

func (o *UnixGroupUsersCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-groups/{svm.uuid}/{unix_group.name}/users][%d] unix_group_users_create default %s", o._statusCode, payload)
}

func (o *UnixGroupUsersCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixGroupUsersCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
