// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixUserCollectionGetParams creates a new UnixUserCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserCollectionGetParams() *UnixUserCollectionGetParams {
	return &UnixUserCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserCollectionGetParamsWithTimeout creates a new UnixUserCollectionGetParams object
// with the ability to set a timeout on a request.
func NewUnixUserCollectionGetParamsWithTimeout(timeout time.Duration) *UnixUserCollectionGetParams {
	return &UnixUserCollectionGetParams{
		timeout: timeout,
	}
}

// NewUnixUserCollectionGetParamsWithContext creates a new UnixUserCollectionGetParams object
// with the ability to set a context for a request.
func NewUnixUserCollectionGetParamsWithContext(ctx context.Context) *UnixUserCollectionGetParams {
	return &UnixUserCollectionGetParams{
		Context: ctx,
	}
}

// NewUnixUserCollectionGetParamsWithHTTPClient creates a new UnixUserCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserCollectionGetParamsWithHTTPClient(client *http.Client) *UnixUserCollectionGetParams {
	return &UnixUserCollectionGetParams{
		HTTPClient: client,
	}
}

/*
UnixUserCollectionGetParams contains all the parameters to send to the API endpoint

	for the unix user collection get operation.

	Typically these are written to a http.Request.
*/
type UnixUserCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FullName.

	   Filter by full_name
	*/
	FullName *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PrimaryGid.

	   Filter by primary_gid
	*/
	PrimaryGid *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserCollectionGetParams) WithDefaults() *UnixUserCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := UnixUserCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithTimeout(timeout time.Duration) *UnixUserCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithContext(ctx context.Context) *UnixUserCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithHTTPClient(client *http.Client) *UnixUserCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithFields(fields []string) *UnixUserCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFullName adds the fullName to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithFullName(fullName *string) *UnixUserCollectionGetParams {
	o.SetFullName(fullName)
	return o
}

// SetFullName adds the fullName to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetFullName(fullName *string) {
	o.FullName = fullName
}

// WithID adds the id to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithID(id *int64) *UnixUserCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithMaxRecords(maxRecords *int64) *UnixUserCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithName(name *string) *UnixUserCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithOrderBy(orderBy []string) *UnixUserCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPrimaryGid adds the primaryGid to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithPrimaryGid(primaryGid *int64) *UnixUserCollectionGetParams {
	o.SetPrimaryGid(primaryGid)
	return o
}

// SetPrimaryGid adds the primaryGid to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetPrimaryGid(primaryGid *int64) {
	o.PrimaryGid = primaryGid
}

// WithReturnRecords adds the returnRecords to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithReturnRecords(returnRecords *bool) *UnixUserCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *UnixUserCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithSvmName(svmName *string) *UnixUserCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the unix user collection get params
func (o *UnixUserCollectionGetParams) WithSvmUUID(svmUUID *string) *UnixUserCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix user collection get params
func (o *UnixUserCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FullName != nil {

		// query param full_name
		var qrFullName string

		if o.FullName != nil {
			qrFullName = *o.FullName
		}
		qFullName := qrFullName
		if qFullName != "" {

			if err := r.SetQueryParam("full_name", qFullName); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PrimaryGid != nil {

		// query param primary_gid
		var qrPrimaryGid int64

		if o.PrimaryGid != nil {
			qrPrimaryGid = *o.PrimaryGid
		}
		qPrimaryGid := swag.FormatInt64(qrPrimaryGid)
		if qPrimaryGid != "" {

			if err := r.SetQueryParam("primary_gid", qPrimaryGid); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamUnixUserCollectionGet binds the parameter fields
func (o *UnixUserCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamUnixUserCollectionGet binds the parameter order_by
func (o *UnixUserCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
