// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserCollectionGetReader is a Reader for the UnixUserCollectionGet structure.
type UnixUserCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixUserCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserCollectionGetOK creates a UnixUserCollectionGetOK with default headers values
func NewUnixUserCollectionGetOK() *UnixUserCollectionGetOK {
	return &UnixUserCollectionGetOK{}
}

/*
UnixUserCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type UnixUserCollectionGetOK struct {
	Payload *models.UnixUserResponse
}

// IsSuccess returns true when this unix user collection get o k response has a 2xx status code
func (o *UnixUserCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user collection get o k response has a 3xx status code
func (o *UnixUserCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user collection get o k response has a 4xx status code
func (o *UnixUserCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user collection get o k response has a 5xx status code
func (o *UnixUserCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user collection get o k response a status code equal to that given
func (o *UnixUserCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix user collection get o k response
func (o *UnixUserCollectionGetOK) Code() int {
	return 200
}

func (o *UnixUserCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/unix-users][%d] unixUserCollectionGetOK %s", 200, payload)
}

func (o *UnixUserCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/unix-users][%d] unixUserCollectionGetOK %s", 200, payload)
}

func (o *UnixUserCollectionGetOK) GetPayload() *models.UnixUserResponse {
	return o.Payload
}

func (o *UnixUserCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UnixUserResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnixUserCollectionGetDefault creates a UnixUserCollectionGetDefault with default headers values
func NewUnixUserCollectionGetDefault(code int) *UnixUserCollectionGetDefault {
	return &UnixUserCollectionGetDefault{
		_statusCode: code,
	}
}

/*
UnixUserCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type UnixUserCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user collection get default response has a 2xx status code
func (o *UnixUserCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user collection get default response has a 3xx status code
func (o *UnixUserCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user collection get default response has a 4xx status code
func (o *UnixUserCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user collection get default response has a 5xx status code
func (o *UnixUserCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user collection get default response a status code equal to that given
func (o *UnixUserCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user collection get default response
func (o *UnixUserCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/unix-users][%d] unix_user_collection_get default %s", o._statusCode, payload)
}

func (o *UnixUserCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/unix-users][%d] unix_user_collection_get default %s", o._statusCode, payload)
}

func (o *UnixUserCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
