// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewUnixUserCreateParams creates a new UnixUserCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserCreateParams() *UnixUserCreateParams {
	return &UnixUserCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserCreateParamsWithTimeout creates a new UnixUserCreateParams object
// with the ability to set a timeout on a request.
func NewUnixUserCreateParamsWithTimeout(timeout time.Duration) *UnixUserCreateParams {
	return &UnixUserCreateParams{
		timeout: timeout,
	}
}

// NewUnixUserCreateParamsWithContext creates a new UnixUserCreateParams object
// with the ability to set a context for a request.
func NewUnixUserCreateParamsWithContext(ctx context.Context) *UnixUserCreateParams {
	return &UnixUserCreateParams{
		Context: ctx,
	}
}

// NewUnixUserCreateParamsWithHTTPClient creates a new UnixUserCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserCreateParamsWithHTTPClient(client *http.Client) *UnixUserCreateParams {
	return &UnixUserCreateParams{
		HTTPClient: client,
	}
}

/*
UnixUserCreateParams contains all the parameters to send to the API endpoint

	for the unix user create operation.

	Typically these are written to a http.Request.
*/
type UnixUserCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.UnixUser

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserCreateParams) WithDefaults() *UnixUserCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := UnixUserCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix user create params
func (o *UnixUserCreateParams) WithTimeout(timeout time.Duration) *UnixUserCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user create params
func (o *UnixUserCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user create params
func (o *UnixUserCreateParams) WithContext(ctx context.Context) *UnixUserCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user create params
func (o *UnixUserCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user create params
func (o *UnixUserCreateParams) WithHTTPClient(client *http.Client) *UnixUserCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user create params
func (o *UnixUserCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the unix user create params
func (o *UnixUserCreateParams) WithInfo(info *models.UnixUser) *UnixUserCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix user create params
func (o *UnixUserCreateParams) SetInfo(info *models.UnixUser) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the unix user create params
func (o *UnixUserCreateParams) WithReturnRecords(returnRecords *bool) *UnixUserCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix user create params
func (o *UnixUserCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
