// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserCreateReader is a Reader for the UnixUserCreate structure.
type UnixUserCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewUnixUserCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserCreateCreated creates a UnixUserCreateCreated with default headers values
func NewUnixUserCreateCreated() *UnixUserCreateCreated {
	return &UnixUserCreateCreated{}
}

/*
UnixUserCreateCreated describes a response with status code 201, with default header values.

Created
*/
type UnixUserCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.UnixUserResponse
}

// IsSuccess returns true when this unix user create created response has a 2xx status code
func (o *UnixUserCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user create created response has a 3xx status code
func (o *UnixUserCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user create created response has a 4xx status code
func (o *UnixUserCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user create created response has a 5xx status code
func (o *UnixUserCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user create created response a status code equal to that given
func (o *UnixUserCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the unix user create created response
func (o *UnixUserCreateCreated) Code() int {
	return 201
}

func (o *UnixUserCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-users][%d] unixUserCreateCreated %s", 201, payload)
}

func (o *UnixUserCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-users][%d] unixUserCreateCreated %s", 201, payload)
}

func (o *UnixUserCreateCreated) GetPayload() *models.UnixUserResponse {
	return o.Payload
}

func (o *UnixUserCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.UnixUserResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnixUserCreateDefault creates a UnixUserCreateDefault with default headers values
func NewUnixUserCreateDefault(code int) *UnixUserCreateDefault {
	return &UnixUserCreateDefault{
		_statusCode: code,
	}
}

/*
	UnixUserCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621706    | The specified SVM UUID is incorrect for the specified SVM name |
| 2621516    | This operation is only supported on a data SVM |
| 23724066   | The specified UNIX user name is too long. Maximum supported length is 64 characters. |
| 3277051    | The specified UNIX user name contains invalid characters. Valid characters are 0-9, A-Z, a-z, \".\", \"_\" and \"-\". |
| 23724128   | The specified UNIX user full-name contains the invalid character ':'. |
| 23724089   | The specified UNIX user full-name is too long. Maximum supported length is 256 characters. |
| 23724055   | Internal error. Failed to create the UNIX user for the SVM. Verify that the cluster is healthy, then try the command again. |
| 23724090   | Configuring individual entries is not supported because file-only configuration is enabled. |
| 3277025    | Failed to create the UNIX user for the SVM because the system limit has been reached. |
*/
type UnixUserCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user create default response has a 2xx status code
func (o *UnixUserCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user create default response has a 3xx status code
func (o *UnixUserCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user create default response has a 4xx status code
func (o *UnixUserCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user create default response has a 5xx status code
func (o *UnixUserCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user create default response a status code equal to that given
func (o *UnixUserCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user create default response
func (o *UnixUserCreateDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-users][%d] unix_user_create default %s", o._statusCode, payload)
}

func (o *UnixUserCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /name-services/unix-users][%d] unix_user_create default %s", o._statusCode, payload)
}

func (o *UnixUserCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
