// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixUserDeleteCollectionParams creates a new UnixUserDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserDeleteCollectionParams() *UnixUserDeleteCollectionParams {
	return &UnixUserDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserDeleteCollectionParamsWithTimeout creates a new UnixUserDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewUnixUserDeleteCollectionParamsWithTimeout(timeout time.Duration) *UnixUserDeleteCollectionParams {
	return &UnixUserDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewUnixUserDeleteCollectionParamsWithContext creates a new UnixUserDeleteCollectionParams object
// with the ability to set a context for a request.
func NewUnixUserDeleteCollectionParamsWithContext(ctx context.Context) *UnixUserDeleteCollectionParams {
	return &UnixUserDeleteCollectionParams{
		Context: ctx,
	}
}

// NewUnixUserDeleteCollectionParamsWithHTTPClient creates a new UnixUserDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserDeleteCollectionParamsWithHTTPClient(client *http.Client) *UnixUserDeleteCollectionParams {
	return &UnixUserDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
UnixUserDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the unix user delete collection operation.

	Typically these are written to a http.Request.
*/
type UnixUserDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* FullName.

	   Filter by full_name
	*/
	FullName *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info UnixUserDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PrimaryGid.

	   Filter by primary_gid
	*/
	PrimaryGid *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserDeleteCollectionParams) WithDefaults() *UnixUserDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := UnixUserDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithTimeout(timeout time.Duration) *UnixUserDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithContext(ctx context.Context) *UnixUserDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithHTTPClient(client *http.Client) *UnixUserDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *UnixUserDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFullName adds the fullName to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithFullName(fullName *string) *UnixUserDeleteCollectionParams {
	o.SetFullName(fullName)
	return o
}

// SetFullName adds the fullName to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetFullName(fullName *string) {
	o.FullName = fullName
}

// WithID adds the id to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithID(id *int64) *UnixUserDeleteCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithInfo(info UnixUserDeleteCollectionBody) *UnixUserDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetInfo(info UnixUserDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithName(name *string) *UnixUserDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPrimaryGid adds the primaryGid to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithPrimaryGid(primaryGid *int64) *UnixUserDeleteCollectionParams {
	o.SetPrimaryGid(primaryGid)
	return o
}

// SetPrimaryGid adds the primaryGid to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetPrimaryGid(primaryGid *int64) {
	o.PrimaryGid = primaryGid
}

// WithReturnRecords adds the returnRecords to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *UnixUserDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *UnixUserDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *UnixUserDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithSvmName(svmName *string) *UnixUserDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) WithSvmUUID(svmUUID *string) *UnixUserDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix user delete collection params
func (o *UnixUserDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.FullName != nil {

		// query param full_name
		var qrFullName string

		if o.FullName != nil {
			qrFullName = *o.FullName
		}
		qFullName := qrFullName
		if qFullName != "" {

			if err := r.SetQueryParam("full_name", qFullName); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PrimaryGid != nil {

		// query param primary_gid
		var qrPrimaryGid int64

		if o.PrimaryGid != nil {
			qrPrimaryGid = *o.PrimaryGid
		}
		qPrimaryGid := swag.FormatInt64(qrPrimaryGid)
		if qPrimaryGid != "" {

			if err := r.SetQueryParam("primary_gid", qPrimaryGid); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
