// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserDeleteCollectionReader is a Reader for the UnixUserDeleteCollection structure.
type UnixUserDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixUserDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserDeleteCollectionOK creates a UnixUserDeleteCollectionOK with default headers values
func NewUnixUserDeleteCollectionOK() *UnixUserDeleteCollectionOK {
	return &UnixUserDeleteCollectionOK{}
}

/*
UnixUserDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type UnixUserDeleteCollectionOK struct {
}

// IsSuccess returns true when this unix user delete collection o k response has a 2xx status code
func (o *UnixUserDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user delete collection o k response has a 3xx status code
func (o *UnixUserDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user delete collection o k response has a 4xx status code
func (o *UnixUserDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user delete collection o k response has a 5xx status code
func (o *UnixUserDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user delete collection o k response a status code equal to that given
func (o *UnixUserDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix user delete collection o k response
func (o *UnixUserDeleteCollectionOK) Code() int {
	return 200
}

func (o *UnixUserDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/unix-users][%d] unixUserDeleteCollectionOK", 200)
}

func (o *UnixUserDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/unix-users][%d] unixUserDeleteCollectionOK", 200)
}

func (o *UnixUserDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixUserDeleteCollectionDefault creates a UnixUserDeleteCollectionDefault with default headers values
func NewUnixUserDeleteCollectionDefault(code int) *UnixUserDeleteCollectionDefault {
	return &UnixUserDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
UnixUserDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type UnixUserDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user delete collection default response has a 2xx status code
func (o *UnixUserDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user delete collection default response has a 3xx status code
func (o *UnixUserDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user delete collection default response has a 4xx status code
func (o *UnixUserDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user delete collection default response has a 5xx status code
func (o *UnixUserDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user delete collection default response a status code equal to that given
func (o *UnixUserDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user delete collection default response
func (o *UnixUserDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-users][%d] unix_user_delete_collection default %s", o._statusCode, payload)
}

func (o *UnixUserDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-users][%d] unix_user_delete_collection default %s", o._statusCode, payload)
}

func (o *UnixUserDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UnixUserDeleteCollectionBody unix user delete collection body
swagger:model UnixUserDeleteCollectionBody
*/
type UnixUserDeleteCollectionBody struct {

	// unix user response inline records
	UnixUserResponseInlineRecords []*models.UnixUser `json:"records,omitempty"`
}

// Validate validates this unix user delete collection body
func (o *UnixUserDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUnixUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserDeleteCollectionBody) validateUnixUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.UnixUserResponseInlineRecords); i++ {
		if swag.IsZero(o.UnixUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.UnixUserResponseInlineRecords[i] != nil {
			if err := o.UnixUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this unix user delete collection body based on the context it is used
func (o *UnixUserDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUnixUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserDeleteCollectionBody) contextValidateUnixUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.UnixUserResponseInlineRecords); i++ {

		if o.UnixUserResponseInlineRecords[i] != nil {
			if err := o.UnixUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixUserDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixUserDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res UnixUserDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
