// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserDeleteReader is a Reader for the UnixUserDelete structure.
type UnixUserDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixUserDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserDeleteOK creates a UnixUserDeleteOK with default headers values
func NewUnixUserDeleteOK() *UnixUserDeleteOK {
	return &UnixUserDeleteOK{}
}

/*
UnixUserDeleteOK describes a response with status code 200, with default header values.

OK
*/
type UnixUserDeleteOK struct {
}

// IsSuccess returns true when this unix user delete o k response has a 2xx status code
func (o *UnixUserDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user delete o k response has a 3xx status code
func (o *UnixUserDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user delete o k response has a 4xx status code
func (o *UnixUserDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user delete o k response has a 5xx status code
func (o *UnixUserDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user delete o k response a status code equal to that given
func (o *UnixUserDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix user delete o k response
func (o *UnixUserDeleteOK) Code() int {
	return 200
}

func (o *UnixUserDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /name-services/unix-users/{svm.uuid}/{name}][%d] unixUserDeleteOK", 200)
}

func (o *UnixUserDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /name-services/unix-users/{svm.uuid}/{name}][%d] unixUserDeleteOK", 200)
}

func (o *UnixUserDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixUserDeleteDefault creates a UnixUserDeleteDefault with default headers values
func NewUnixUserDeleteDefault(code int) *UnixUserDeleteDefault {
	return &UnixUserDeleteDefault{
		_statusCode: code,
	}
}

/*
UnixUserDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type UnixUserDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user delete default response has a 2xx status code
func (o *UnixUserDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user delete default response has a 3xx status code
func (o *UnixUserDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user delete default response has a 4xx status code
func (o *UnixUserDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user delete default response has a 5xx status code
func (o *UnixUserDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user delete default response a status code equal to that given
func (o *UnixUserDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user delete default response
func (o *UnixUserDeleteDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-users/{svm.uuid}/{name}][%d] unix_user_delete default %s", o._statusCode, payload)
}

func (o *UnixUserDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /name-services/unix-users/{svm.uuid}/{name}][%d] unix_user_delete default %s", o._statusCode, payload)
}

func (o *UnixUserDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
