// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixUserGetParams creates a new UnixUserGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserGetParams() *UnixUserGetParams {
	return &UnixUserGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserGetParamsWithTimeout creates a new UnixUserGetParams object
// with the ability to set a timeout on a request.
func NewUnixUserGetParamsWithTimeout(timeout time.Duration) *UnixUserGetParams {
	return &UnixUserGetParams{
		timeout: timeout,
	}
}

// NewUnixUserGetParamsWithContext creates a new UnixUserGetParams object
// with the ability to set a context for a request.
func NewUnixUserGetParamsWithContext(ctx context.Context) *UnixUserGetParams {
	return &UnixUserGetParams{
		Context: ctx,
	}
}

// NewUnixUserGetParamsWithHTTPClient creates a new UnixUserGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserGetParamsWithHTTPClient(client *http.Client) *UnixUserGetParams {
	return &UnixUserGetParams{
		HTTPClient: client,
	}
}

/*
UnixUserGetParams contains all the parameters to send to the API endpoint

	for the unix user get operation.

	Typically these are written to a http.Request.
*/
type UnixUserGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   UNIX user name
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserGetParams) WithDefaults() *UnixUserGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unix user get params
func (o *UnixUserGetParams) WithTimeout(timeout time.Duration) *UnixUserGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user get params
func (o *UnixUserGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user get params
func (o *UnixUserGetParams) WithContext(ctx context.Context) *UnixUserGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user get params
func (o *UnixUserGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user get params
func (o *UnixUserGetParams) WithHTTPClient(client *http.Client) *UnixUserGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user get params
func (o *UnixUserGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the unix user get params
func (o *UnixUserGetParams) WithFields(fields []string) *UnixUserGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the unix user get params
func (o *UnixUserGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the unix user get params
func (o *UnixUserGetParams) WithName(name string) *UnixUserGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix user get params
func (o *UnixUserGetParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the unix user get params
func (o *UnixUserGetParams) WithSvmUUID(svmUUID string) *UnixUserGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix user get params
func (o *UnixUserGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamUnixUserGet binds the parameter fields
func (o *UnixUserGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
