// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixUserModifyCollectionParams creates a new UnixUserModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserModifyCollectionParams() *UnixUserModifyCollectionParams {
	return &UnixUserModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserModifyCollectionParamsWithTimeout creates a new UnixUserModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewUnixUserModifyCollectionParamsWithTimeout(timeout time.Duration) *UnixUserModifyCollectionParams {
	return &UnixUserModifyCollectionParams{
		timeout: timeout,
	}
}

// NewUnixUserModifyCollectionParamsWithContext creates a new UnixUserModifyCollectionParams object
// with the ability to set a context for a request.
func NewUnixUserModifyCollectionParamsWithContext(ctx context.Context) *UnixUserModifyCollectionParams {
	return &UnixUserModifyCollectionParams{
		Context: ctx,
	}
}

// NewUnixUserModifyCollectionParamsWithHTTPClient creates a new UnixUserModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserModifyCollectionParamsWithHTTPClient(client *http.Client) *UnixUserModifyCollectionParams {
	return &UnixUserModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
UnixUserModifyCollectionParams contains all the parameters to send to the API endpoint

	for the unix user modify collection operation.

	Typically these are written to a http.Request.
*/
type UnixUserModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* FullName.

	   Filter by full_name
	*/
	FullName *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info UnixUserModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PrimaryGid.

	   Filter by primary_gid
	*/
	PrimaryGid *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserModifyCollectionParams) WithDefaults() *UnixUserModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := UnixUserModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithTimeout(timeout time.Duration) *UnixUserModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithContext(ctx context.Context) *UnixUserModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithHTTPClient(client *http.Client) *UnixUserModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *UnixUserModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFullName adds the fullName to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithFullName(fullName *string) *UnixUserModifyCollectionParams {
	o.SetFullName(fullName)
	return o
}

// SetFullName adds the fullName to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetFullName(fullName *string) {
	o.FullName = fullName
}

// WithID adds the id to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithID(id *int64) *UnixUserModifyCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithInfo(info UnixUserModifyCollectionBody) *UnixUserModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetInfo(info UnixUserModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithName(name *string) *UnixUserModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPrimaryGid adds the primaryGid to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithPrimaryGid(primaryGid *int64) *UnixUserModifyCollectionParams {
	o.SetPrimaryGid(primaryGid)
	return o
}

// SetPrimaryGid adds the primaryGid to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetPrimaryGid(primaryGid *int64) {
	o.PrimaryGid = primaryGid
}

// WithReturnRecords adds the returnRecords to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithReturnRecords(returnRecords *bool) *UnixUserModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *UnixUserModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithSerialRecords(serialRecords *bool) *UnixUserModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithSvmName(svmName *string) *UnixUserModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) WithSvmUUID(svmUUID *string) *UnixUserModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix user modify collection params
func (o *UnixUserModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.FullName != nil {

		// query param full_name
		var qrFullName string

		if o.FullName != nil {
			qrFullName = *o.FullName
		}
		qFullName := qrFullName
		if qFullName != "" {

			if err := r.SetQueryParam("full_name", qFullName); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PrimaryGid != nil {

		// query param primary_gid
		var qrPrimaryGid int64

		if o.PrimaryGid != nil {
			qrPrimaryGid = *o.PrimaryGid
		}
		qPrimaryGid := swag.FormatInt64(qrPrimaryGid)
		if qPrimaryGid != "" {

			if err := r.SetQueryParam("primary_gid", qPrimaryGid); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
