// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserSettingsCollectionGetReader is a Reader for the UnixUserSettingsCollectionGet structure.
type UnixUserSettingsCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserSettingsCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixUserSettingsCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserSettingsCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserSettingsCollectionGetOK creates a UnixUserSettingsCollectionGetOK with default headers values
func NewUnixUserSettingsCollectionGetOK() *UnixUserSettingsCollectionGetOK {
	return &UnixUserSettingsCollectionGetOK{}
}

/*
UnixUserSettingsCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type UnixUserSettingsCollectionGetOK struct {
	Payload *models.UnixUserSettingsResponse
}

// IsSuccess returns true when this unix user settings collection get o k response has a 2xx status code
func (o *UnixUserSettingsCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user settings collection get o k response has a 3xx status code
func (o *UnixUserSettingsCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user settings collection get o k response has a 4xx status code
func (o *UnixUserSettingsCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user settings collection get o k response has a 5xx status code
func (o *UnixUserSettingsCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user settings collection get o k response a status code equal to that given
func (o *UnixUserSettingsCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix user settings collection get o k response
func (o *UnixUserSettingsCollectionGetOK) Code() int {
	return 200
}

func (o *UnixUserSettingsCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-user/settings][%d] unixUserSettingsCollectionGetOK %s", 200, payload)
}

func (o *UnixUserSettingsCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-user/settings][%d] unixUserSettingsCollectionGetOK %s", 200, payload)
}

func (o *UnixUserSettingsCollectionGetOK) GetPayload() *models.UnixUserSettingsResponse {
	return o.Payload
}

func (o *UnixUserSettingsCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UnixUserSettingsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnixUserSettingsCollectionGetDefault creates a UnixUserSettingsCollectionGetDefault with default headers values
func NewUnixUserSettingsCollectionGetDefault(code int) *UnixUserSettingsCollectionGetDefault {
	return &UnixUserSettingsCollectionGetDefault{
		_statusCode: code,
	}
}

/*
UnixUserSettingsCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type UnixUserSettingsCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user settings collection get default response has a 2xx status code
func (o *UnixUserSettingsCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user settings collection get default response has a 3xx status code
func (o *UnixUserSettingsCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user settings collection get default response has a 4xx status code
func (o *UnixUserSettingsCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user settings collection get default response has a 5xx status code
func (o *UnixUserSettingsCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user settings collection get default response a status code equal to that given
func (o *UnixUserSettingsCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user settings collection get default response
func (o *UnixUserSettingsCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserSettingsCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-user/settings][%d] unix_user_settings_collection_get default %s", o._statusCode, payload)
}

func (o *UnixUserSettingsCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /name-services/cache/unix-user/settings][%d] unix_user_settings_collection_get default %s", o._statusCode, payload)
}

func (o *UnixUserSettingsCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserSettingsCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
