// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUnixUserSettingsModifyCollectionParams creates a new UnixUserSettingsModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnixUserSettingsModifyCollectionParams() *UnixUserSettingsModifyCollectionParams {
	return &UnixUserSettingsModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnixUserSettingsModifyCollectionParamsWithTimeout creates a new UnixUserSettingsModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewUnixUserSettingsModifyCollectionParamsWithTimeout(timeout time.Duration) *UnixUserSettingsModifyCollectionParams {
	return &UnixUserSettingsModifyCollectionParams{
		timeout: timeout,
	}
}

// NewUnixUserSettingsModifyCollectionParamsWithContext creates a new UnixUserSettingsModifyCollectionParams object
// with the ability to set a context for a request.
func NewUnixUserSettingsModifyCollectionParamsWithContext(ctx context.Context) *UnixUserSettingsModifyCollectionParams {
	return &UnixUserSettingsModifyCollectionParams{
		Context: ctx,
	}
}

// NewUnixUserSettingsModifyCollectionParamsWithHTTPClient creates a new UnixUserSettingsModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnixUserSettingsModifyCollectionParamsWithHTTPClient(client *http.Client) *UnixUserSettingsModifyCollectionParams {
	return &UnixUserSettingsModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
UnixUserSettingsModifyCollectionParams contains all the parameters to send to the API endpoint

	for the unix user settings modify collection operation.

	Typically these are written to a http.Request.
*/
type UnixUserSettingsModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info UnixUserSettingsModifyCollectionBody

	/* NegativeCacheEnabled.

	   Filter by negative_cache_enabled
	*/
	NegativeCacheEnabled *bool

	/* NegativeTTL.

	   Filter by negative_ttl
	*/
	NegativeTTL *string

	/* PropagationEnabled.

	   Filter by propagation_enabled
	*/
	PropagationEnabled *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TTL.

	   Filter by ttl
	*/
	TTL *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unix user settings modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserSettingsModifyCollectionParams) WithDefaults() *UnixUserSettingsModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unix user settings modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnixUserSettingsModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := UnixUserSettingsModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithTimeout(timeout time.Duration) *UnixUserSettingsModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithContext(ctx context.Context) *UnixUserSettingsModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithHTTPClient(client *http.Client) *UnixUserSettingsModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithEnabled(enabled *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithInfo(info UnixUserSettingsModifyCollectionBody) *UnixUserSettingsModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetInfo(info UnixUserSettingsModifyCollectionBody) {
	o.Info = info
}

// WithNegativeCacheEnabled adds the negativeCacheEnabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithNegativeCacheEnabled(negativeCacheEnabled *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetNegativeCacheEnabled(negativeCacheEnabled)
	return o
}

// SetNegativeCacheEnabled adds the negativeCacheEnabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetNegativeCacheEnabled(negativeCacheEnabled *bool) {
	o.NegativeCacheEnabled = negativeCacheEnabled
}

// WithNegativeTTL adds the negativeTTL to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithNegativeTTL(negativeTTL *string) *UnixUserSettingsModifyCollectionParams {
	o.SetNegativeTTL(negativeTTL)
	return o
}

// SetNegativeTTL adds the negativeTtl to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetNegativeTTL(negativeTTL *string) {
	o.NegativeTTL = negativeTTL
}

// WithPropagationEnabled adds the propagationEnabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithPropagationEnabled(propagationEnabled *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetPropagationEnabled(propagationEnabled)
	return o
}

// SetPropagationEnabled adds the propagationEnabled to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetPropagationEnabled(propagationEnabled *bool) {
	o.PropagationEnabled = propagationEnabled
}

// WithReturnRecords adds the returnRecords to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithReturnRecords(returnRecords *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *UnixUserSettingsModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithSerialRecords(serialRecords *bool) *UnixUserSettingsModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithSvmName(svmName *string) *UnixUserSettingsModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithSvmUUID(svmUUID *string) *UnixUserSettingsModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTTL adds the ttl to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) WithTTL(ttl *string) *UnixUserSettingsModifyCollectionParams {
	o.SetTTL(ttl)
	return o
}

// SetTTL adds the ttl to the unix user settings modify collection params
func (o *UnixUserSettingsModifyCollectionParams) SetTTL(ttl *string) {
	o.TTL = ttl
}

// WriteToRequest writes these params to a swagger request
func (o *UnixUserSettingsModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NegativeCacheEnabled != nil {

		// query param negative_cache_enabled
		var qrNegativeCacheEnabled bool

		if o.NegativeCacheEnabled != nil {
			qrNegativeCacheEnabled = *o.NegativeCacheEnabled
		}
		qNegativeCacheEnabled := swag.FormatBool(qrNegativeCacheEnabled)
		if qNegativeCacheEnabled != "" {

			if err := r.SetQueryParam("negative_cache_enabled", qNegativeCacheEnabled); err != nil {
				return err
			}
		}
	}

	if o.NegativeTTL != nil {

		// query param negative_ttl
		var qrNegativeTTL string

		if o.NegativeTTL != nil {
			qrNegativeTTL = *o.NegativeTTL
		}
		qNegativeTTL := qrNegativeTTL
		if qNegativeTTL != "" {

			if err := r.SetQueryParam("negative_ttl", qNegativeTTL); err != nil {
				return err
			}
		}
	}

	if o.PropagationEnabled != nil {

		// query param propagation_enabled
		var qrPropagationEnabled bool

		if o.PropagationEnabled != nil {
			qrPropagationEnabled = *o.PropagationEnabled
		}
		qPropagationEnabled := swag.FormatBool(qrPropagationEnabled)
		if qPropagationEnabled != "" {

			if err := r.SetQueryParam("propagation_enabled", qPropagationEnabled); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TTL != nil {

		// query param ttl
		var qrTTL string

		if o.TTL != nil {
			qrTTL = *o.TTL
		}
		qTTL := qrTTL
		if qTTL != "" {

			if err := r.SetQueryParam("ttl", qTTL); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
