// Code generated by go-swagger; DO NOT EDIT.

package name_services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// UnixUserSettingsModifyCollectionReader is a Reader for the UnixUserSettingsModifyCollection structure.
type UnixUserSettingsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnixUserSettingsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnixUserSettingsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnixUserSettingsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnixUserSettingsModifyCollectionOK creates a UnixUserSettingsModifyCollectionOK with default headers values
func NewUnixUserSettingsModifyCollectionOK() *UnixUserSettingsModifyCollectionOK {
	return &UnixUserSettingsModifyCollectionOK{}
}

/*
UnixUserSettingsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type UnixUserSettingsModifyCollectionOK struct {
}

// IsSuccess returns true when this unix user settings modify collection o k response has a 2xx status code
func (o *UnixUserSettingsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unix user settings modify collection o k response has a 3xx status code
func (o *UnixUserSettingsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unix user settings modify collection o k response has a 4xx status code
func (o *UnixUserSettingsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unix user settings modify collection o k response has a 5xx status code
func (o *UnixUserSettingsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unix user settings modify collection o k response a status code equal to that given
func (o *UnixUserSettingsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unix user settings modify collection o k response
func (o *UnixUserSettingsModifyCollectionOK) Code() int {
	return 200
}

func (o *UnixUserSettingsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /name-services/cache/unix-user/settings][%d] unixUserSettingsModifyCollectionOK", 200)
}

func (o *UnixUserSettingsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /name-services/cache/unix-user/settings][%d] unixUserSettingsModifyCollectionOK", 200)
}

func (o *UnixUserSettingsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUnixUserSettingsModifyCollectionDefault creates a UnixUserSettingsModifyCollectionDefault with default headers values
func NewUnixUserSettingsModifyCollectionDefault(code int) *UnixUserSettingsModifyCollectionDefault {
	return &UnixUserSettingsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	UnixUserSettingsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 23724055 | Internal error. Configuration for Vserver failed. Verify that the cluster is healthy, then try the command again. For further assistance, contact technical support. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type UnixUserSettingsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this unix user settings modify collection default response has a 2xx status code
func (o *UnixUserSettingsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unix user settings modify collection default response has a 3xx status code
func (o *UnixUserSettingsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unix user settings modify collection default response has a 4xx status code
func (o *UnixUserSettingsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unix user settings modify collection default response has a 5xx status code
func (o *UnixUserSettingsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unix user settings modify collection default response a status code equal to that given
func (o *UnixUserSettingsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unix user settings modify collection default response
func (o *UnixUserSettingsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *UnixUserSettingsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/unix-user/settings][%d] unix_user_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *UnixUserSettingsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /name-services/cache/unix-user/settings][%d] unix_user_settings_modify_collection default %s", o._statusCode, payload)
}

func (o *UnixUserSettingsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *UnixUserSettingsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UnixUserSettingsModifyCollectionBody unix user settings modify collection body
swagger:model UnixUserSettingsModifyCollectionBody
*/
type UnixUserSettingsModifyCollectionBody struct {

	// links
	Links *models.UnixUserSettingsInlineLinks `json:"_links,omitempty"`

	// Indicates whether or not the cache is enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// Indicates whether or not the negative cache is enabled.
	//
	NegativeCacheEnabled *bool `json:"negative_cache_enabled,omitempty"`

	// Specifies negative Time to Live, in ISO 8601 format.
	//
	// Example: PT5M
	NegativeTTL *string `json:"negative_ttl,omitempty"`

	// Specifies whether the propagation setting is enabled or not.
	//
	PropagationEnabled *bool `json:"propagation_enabled,omitempty"`

	// svm
	Svm *models.UnixUserSettingsInlineSvm `json:"svm,omitempty"`

	// Specifies Time to Live (TTL), in ISO 8601 format.
	//
	// Example: PT2H
	TTL *string `json:"ttl,omitempty"`

	// unix user settings response inline records
	UnixUserSettingsResponseInlineRecords []*models.UnixUserSettings `json:"records,omitempty"`
}

// Validate validates this unix user settings modify collection body
func (o *UnixUserSettingsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnixUserSettingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) validateUnixUserSettingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.UnixUserSettingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.UnixUserSettingsResponseInlineRecords); i++ {
		if swag.IsZero(o.UnixUserSettingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.UnixUserSettingsResponseInlineRecords[i] != nil {
			if err := o.UnixUserSettingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this unix user settings modify collection body based on the context it is used
func (o *UnixUserSettingsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnixUserSettingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *UnixUserSettingsModifyCollectionBody) contextValidateUnixUserSettingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.UnixUserSettingsResponseInlineRecords); i++ {

		if o.UnixUserSettingsResponseInlineRecords[i] != nil {
			if err := o.UnixUserSettingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixUserSettingsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixUserSettingsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res UnixUserSettingsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixUserSettingsInlineLinks unix user settings inline links
swagger:model unix_user_settings_inline__links
*/
type UnixUserSettingsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this unix user settings inline links
func (o *UnixUserSettingsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix user settings inline links based on the context it is used
func (o *UnixUserSettingsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixUserSettingsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixUserSettingsInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixUserSettingsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixUserSettingsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model unix_user_settings_inline_svm
*/
type UnixUserSettingsInlineSvm struct {

	// links
	Links *models.UnixUserSettingsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this unix user settings inline svm
func (o *UnixUserSettingsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix user settings inline svm based on the context it is used
func (o *UnixUserSettingsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixUserSettingsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixUserSettingsInlineSvm) UnmarshalBinary(b []byte) error {
	var res UnixUserSettingsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UnixUserSettingsInlineSvmInlineLinks unix user settings inline svm inline links
swagger:model unix_user_settings_inline_svm_inline__links
*/
type UnixUserSettingsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this unix user settings inline svm inline links
func (o *UnixUserSettingsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this unix user settings inline svm inline links based on the context it is used
func (o *UnixUserSettingsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UnixUserSettingsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UnixUserSettingsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UnixUserSettingsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res UnixUserSettingsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
