// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new ndmp API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for ndmp API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ClusterNdmpGet(params *ClusterNdmpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNdmpGetOK, error)

	ClusterNdmpModify(params *ClusterNdmpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNdmpModifyOK, error)

	NdmpNodeCollectionGet(params *NdmpNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeCollectionGetOK, error)

	NdmpNodeGet(params *NdmpNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeGetOK, error)

	NdmpNodeModify(params *NdmpNodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeModifyOK, error)

	NdmpNodeModifyCollection(params *NdmpNodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeModifyCollectionOK, error)

	NdmpNodeSessionDelete(params *NdmpNodeSessionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionDeleteOK, error)

	NdmpNodeSessionDeleteCollection(params *NdmpNodeSessionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionDeleteCollectionOK, error)

	NdmpNodeSessionGet(params *NdmpNodeSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionGetOK, error)

	NdmpNodeSessionsCollectionGet(params *NdmpNodeSessionsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionsCollectionGetOK, error)

	NdmpPasswordGet(params *NdmpPasswordGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpPasswordGetOK, error)

	NdmpSvmCollectionGet(params *NdmpSvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmCollectionGetOK, error)

	NdmpSvmGet(params *NdmpSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmGetOK, error)

	NdmpSvmModify(params *NdmpSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmModifyOK, error)

	NdmpSvmModifyCollection(params *NdmpSvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmModifyCollectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	ClusterNdmpGet Retrieves the current NDMP mode.

### Related ONTAP commands
* `system services ndmp node-scope-mode status`
### Learn more
* [`DOC /protocols/ndmp`](#docs-ndmp-protocols_ndmp)
*/
func (a *Client) ClusterNdmpGet(params *ClusterNdmpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNdmpGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNdmpGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ndmp_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNdmpGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNdmpGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNdmpGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNdmpModify Updates the NDMP mode.

### Related ONTAP commands
* `system services ndmp node-scope-mode`
### Learn more
* [`DOC /protocols/ndmp`](#docs-ndmp-protocols_ndmp)
*/
func (a *Client) ClusterNdmpModify(params *ClusterNdmpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNdmpModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNdmpModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ndmp_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/ndmp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNdmpModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNdmpModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNdmpModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeCollectionGet Retrieves NDMP node configurations for all of the nodes.

### Related ONTAP commands
* `system services ndmp show`
### Learn more
* [`DOC /protocols/ndmp/nodes`](#docs-ndmp-protocols_ndmp_nodes)
*/
func (a *Client) NdmpNodeCollectionGet(params *NdmpNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeGet Retrieves an NDMP node configuration for a specific node.

### Related ONTAP commands
* `system services ndmp show`
### Learn more
* [`DOC /protocols/ndmp/nodes`](#docs-ndmp-protocols_ndmp_nodes)
*/
func (a *Client) NdmpNodeGet(params *NdmpNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/nodes/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeModify Updates the NDMP node configuration for a specific node.

### Related ONTAP commands
* `system services ndmp modify`
### Learn more
* [`DOC /protocols/ndmp/nodes`](#docs-ndmp-protocols_ndmp_nodes)
*/
func (a *Client) NdmpNodeModify(params *NdmpNodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/ndmp/nodes/{node.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NdmpNodeModifyCollection ndmp node modify collection API
*/
func (a *Client) NdmpNodeModifyCollection(params *NdmpNodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/ndmp/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeSessionDelete Deletes a specific NDMP session.

### Related ONTAP commands
* `vserver services ndmp kill`
* `system services ndmp kill`
### Learn more
* [`DOC /protocols/ndmp/sessions`](#docs-ndmp-protocols_ndmp_sessions)
*/
func (a *Client) NdmpNodeSessionDelete(params *NdmpNodeSessionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeSessionDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_session_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/ndmp/sessions/{owner.uuid}/{session.id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeSessionDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeSessionDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeSessionDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NdmpNodeSessionDeleteCollection ndmp node session delete collection API
*/
func (a *Client) NdmpNodeSessionDeleteCollection(params *NdmpNodeSessionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeSessionDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_session_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/ndmp/sessions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeSessionDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeSessionDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeSessionDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeSessionGet Retrieves the details of a specific NDMP session.

### Related ONTAP commands
* `vserver services ndmp probe`
* `system services ndmp probe`
### Learn more
* [`DOC /protocols/ndmp/sessions`](#docs-ndmp-protocols_ndmp_sessions)
*/
func (a *Client) NdmpNodeSessionGet(params *NdmpNodeSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeSessionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_session_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/sessions/{owner.uuid}/{session.id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeSessionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeSessionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeSessionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpNodeSessionsCollectionGet Retrieves a collection of NDMP sessions. In the case of SVM-scope, if this API is executed on a data IP, it displays the list of NDMP sessions under the specified SVM; otherwise it displays the list of NDMP sessions for all the SVMs under the cluster. In the case of node-scope, it displays the list of NDMP sessions for all nodes.

### Related ONTAP commands
* `vserver services ndmp probe`
* `system services ndmp probe`
### Learn more
* [`DOC /protocols/ndmp/sessions`](#docs-ndmp-protocols_ndmp_sessions)
*/
func (a *Client) NdmpNodeSessionsCollectionGet(params *NdmpNodeSessionsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpNodeSessionsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpNodeSessionsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_node_sessions_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/sessions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpNodeSessionsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpNodeSessionsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpNodeSessionsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpPasswordGet Generates and retrieves the password for the specified NDMP user.

### Related ONTAP commands
* `vserver services ndmp generate-password`
### Learn more
* [`DOC /protocols/ndmp/svms/{svm.uuid}/passwords/{user}`](#docs-ndmp-protocols_ndmp_svms_{svm.uuid}_passwords_{user})
*/
func (a *Client) NdmpPasswordGet(params *NdmpPasswordGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpPasswordGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpPasswordGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_password_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/svms/{svm.uuid}/passwords/{user}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpPasswordGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpPasswordGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpPasswordGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpSvmCollectionGet Retrieves NDMP configurations for all SVMs.

### Related ONTAP commands
* `vserver services ndmp show`
### Learn more
* [`DOC /protocols/ndmp/svms`](#docs-ndmp-protocols_ndmp_svms)
*/
func (a *Client) NdmpSvmCollectionGet(params *NdmpSvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpSvmCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_svm_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpSvmCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpSvmCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpSvmCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpSvmGet Retrieves an NDMP configuration for a specific SVM.

### Related ONTAP commands
* `vserver services ndmp show`
### Learn more
* [`DOC /protocols/ndmp/svms`](#docs-ndmp-protocols_ndmp_svms)
*/
func (a *Client) NdmpSvmGet(params *NdmpSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpSvmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_svm_get",
		Method:             "GET",
		PathPattern:        "/protocols/ndmp/svms/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpSvmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpSvmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpSvmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NdmpSvmModify Updates the NDMP configuration for a specific SVM.

### Related ONTAP commands
* `vserver services ndmp modify`
### Learn more
* [`DOC /protocols/ndmp/svms`](#docs-ndmp-protocols_ndmp_svms)
*/
func (a *Client) NdmpSvmModify(params *NdmpSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpSvmModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_svm_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/ndmp/svms/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpSvmModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpSvmModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpSvmModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NdmpSvmModifyCollection ndmp svm modify collection API
*/
func (a *Client) NdmpSvmModifyCollection(params *NdmpSvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NdmpSvmModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNdmpSvmModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ndmp_svm_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/ndmp/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NdmpSvmModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NdmpSvmModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NdmpSvmModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
