// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NdmpNodeGetReader is a Reader for the NdmpNodeGet structure.
type NdmpNodeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NdmpNodeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNdmpNodeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNdmpNodeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNdmpNodeGetOK creates a NdmpNodeGetOK with default headers values
func NewNdmpNodeGetOK() *NdmpNodeGetOK {
	return &NdmpNodeGetOK{}
}

/*
NdmpNodeGetOK describes a response with status code 200, with default header values.

OK
*/
type NdmpNodeGetOK struct {
	Payload *models.NdmpNode
}

// IsSuccess returns true when this ndmp node get o k response has a 2xx status code
func (o *NdmpNodeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ndmp node get o k response has a 3xx status code
func (o *NdmpNodeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ndmp node get o k response has a 4xx status code
func (o *NdmpNodeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ndmp node get o k response has a 5xx status code
func (o *NdmpNodeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ndmp node get o k response a status code equal to that given
func (o *NdmpNodeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ndmp node get o k response
func (o *NdmpNodeGetOK) Code() int {
	return 200
}

func (o *NdmpNodeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/ndmp/nodes/{node.uuid}][%d] ndmpNodeGetOK %s", 200, payload)
}

func (o *NdmpNodeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/ndmp/nodes/{node.uuid}][%d] ndmpNodeGetOK %s", 200, payload)
}

func (o *NdmpNodeGetOK) GetPayload() *models.NdmpNode {
	return o.Payload
}

func (o *NdmpNodeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NdmpNode)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNdmpNodeGetDefault creates a NdmpNodeGetDefault with default headers values
func NewNdmpNodeGetDefault(code int) *NdmpNodeGetDefault {
	return &NdmpNodeGetDefault{
		_statusCode: code,
	}
}

/*
	NdmpNodeGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 68812801    | Node-scoped operations are not allowed in an SVM-scope.|
| 68812802    | The UUID is not valid.|
| 68812804    | Failed to get the node name from the specified node UUID.|
*/
type NdmpNodeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ndmp node get default response has a 2xx status code
func (o *NdmpNodeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ndmp node get default response has a 3xx status code
func (o *NdmpNodeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ndmp node get default response has a 4xx status code
func (o *NdmpNodeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ndmp node get default response has a 5xx status code
func (o *NdmpNodeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ndmp node get default response a status code equal to that given
func (o *NdmpNodeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ndmp node get default response
func (o *NdmpNodeGetDefault) Code() int {
	return o._statusCode
}

func (o *NdmpNodeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/ndmp/nodes/{node.uuid}][%d] ndmp_node_get default %s", o._statusCode, payload)
}

func (o *NdmpNodeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/ndmp/nodes/{node.uuid}][%d] ndmp_node_get default %s", o._statusCode, payload)
}

func (o *NdmpNodeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NdmpNodeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
