// Code generated by go-swagger; DO NOT EDIT.

package ndmp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NdmpNodeModifyCollectionReader is a Reader for the NdmpNodeModifyCollection structure.
type NdmpNodeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NdmpNodeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNdmpNodeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNdmpNodeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNdmpNodeModifyCollectionOK creates a NdmpNodeModifyCollectionOK with default headers values
func NewNdmpNodeModifyCollectionOK() *NdmpNodeModifyCollectionOK {
	return &NdmpNodeModifyCollectionOK{}
}

/*
NdmpNodeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NdmpNodeModifyCollectionOK struct {
	Payload *models.NdmpNode
}

// IsSuccess returns true when this ndmp node modify collection o k response has a 2xx status code
func (o *NdmpNodeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ndmp node modify collection o k response has a 3xx status code
func (o *NdmpNodeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ndmp node modify collection o k response has a 4xx status code
func (o *NdmpNodeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ndmp node modify collection o k response has a 5xx status code
func (o *NdmpNodeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ndmp node modify collection o k response a status code equal to that given
func (o *NdmpNodeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ndmp node modify collection o k response
func (o *NdmpNodeModifyCollectionOK) Code() int {
	return 200
}

func (o *NdmpNodeModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/ndmp/nodes][%d] ndmpNodeModifyCollectionOK %s", 200, payload)
}

func (o *NdmpNodeModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/ndmp/nodes][%d] ndmpNodeModifyCollectionOK %s", 200, payload)
}

func (o *NdmpNodeModifyCollectionOK) GetPayload() *models.NdmpNode {
	return o.Payload
}

func (o *NdmpNodeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NdmpNode)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNdmpNodeModifyCollectionDefault creates a NdmpNodeModifyCollectionDefault with default headers values
func NewNdmpNodeModifyCollectionDefault(code int) *NdmpNodeModifyCollectionDefault {
	return &NdmpNodeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NdmpNodeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error code  |  Description |
|-------------|--------------|
| 68812800    | The user is required to enable NDMP on a node.|
| 68812801    | Node-scoped operations are not allowed in an SVM-scope.|
| 68812802    | The UUID is not valid.|
*/
type NdmpNodeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ndmp node modify collection default response has a 2xx status code
func (o *NdmpNodeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ndmp node modify collection default response has a 3xx status code
func (o *NdmpNodeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ndmp node modify collection default response has a 4xx status code
func (o *NdmpNodeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ndmp node modify collection default response has a 5xx status code
func (o *NdmpNodeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ndmp node modify collection default response a status code equal to that given
func (o *NdmpNodeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ndmp node modify collection default response
func (o *NdmpNodeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NdmpNodeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/ndmp/nodes][%d] ndmp_node_modify_collection default %s", o._statusCode, payload)
}

func (o *NdmpNodeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/ndmp/nodes][%d] ndmp_node_modify_collection default %s", o._statusCode, payload)
}

func (o *NdmpNodeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NdmpNodeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NdmpNodeModifyCollectionBody ndmp node modify collection body
swagger:model NdmpNodeModifyCollectionBody
*/
type NdmpNodeModifyCollectionBody struct {

	// links
	Links *models.NdmpNodeInlineLinks `json:"_links,omitempty"`

	// Is the NDMP service enabled?
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// NDMP authentication types.
	// Example: ["plaintext","challenge"]
	NdmpNodeInlineAuthenticationTypes []*models.NdmpAuthType `json:"authentication_types,omitempty"`

	// ndmp node response inline records
	NdmpNodeResponseInlineRecords []*models.NdmpNode `json:"records,omitempty"`

	// node
	Node *models.NdmpNodeInlineNode `json:"node,omitempty"`

	// NDMP password. This can only be set and cannot be read back.
	Password *string `json:"password,omitempty"`

	// NDMP user ID
	// Example: ndmp_user
	User *string `json:"user,omitempty"`
}

// Validate validates this ndmp node modify collection body
func (o *NdmpNodeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNdmpNodeInlineAuthenticationTypes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNdmpNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) validateNdmpNodeInlineAuthenticationTypes(formats strfmt.Registry) error {
	if swag.IsZero(o.NdmpNodeInlineAuthenticationTypes) { // not required
		return nil
	}

	for i := 0; i < len(o.NdmpNodeInlineAuthenticationTypes); i++ {
		if swag.IsZero(o.NdmpNodeInlineAuthenticationTypes[i]) { // not required
			continue
		}

		if o.NdmpNodeInlineAuthenticationTypes[i] != nil {
			if err := o.NdmpNodeInlineAuthenticationTypes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "authentication_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) validateNdmpNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NdmpNodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NdmpNodeResponseInlineRecords); i++ {
		if swag.IsZero(o.NdmpNodeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NdmpNodeResponseInlineRecords[i] != nil {
			if err := o.NdmpNodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ndmp node modify collection body based on the context it is used
func (o *NdmpNodeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNdmpNodeInlineAuthenticationTypes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNdmpNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) contextValidateNdmpNodeInlineAuthenticationTypes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NdmpNodeInlineAuthenticationTypes); i++ {

		if o.NdmpNodeInlineAuthenticationTypes[i] != nil {
			if err := o.NdmpNodeInlineAuthenticationTypes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "authentication_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) contextValidateNdmpNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NdmpNodeResponseInlineRecords); i++ {

		if o.NdmpNodeResponseInlineRecords[i] != nil {
			if err := o.NdmpNodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NdmpNodeModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NdmpNodeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NdmpNodeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NdmpNodeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NdmpNodeInlineLinks ndmp node inline links
swagger:model ndmp_node_inline__links
*/
type NdmpNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ndmp node inline links
func (o *NdmpNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ndmp node inline links based on the context it is used
func (o *NdmpNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NdmpNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NdmpNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NdmpNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NdmpNodeInlineNode Storage system node
swagger:model ndmp_node_inline_node
*/
type NdmpNodeInlineNode struct {

	// links
	Links *models.NdmpNodeInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ndmp node inline node
func (o *NdmpNodeInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ndmp node inline node based on the context it is used
func (o *NdmpNodeInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NdmpNodeInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NdmpNodeInlineNode) UnmarshalBinary(b []byte) error {
	var res NdmpNodeInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NdmpNodeInlineNodeInlineLinks ndmp node inline node inline links
swagger:model ndmp_node_inline_node_inline__links
*/
type NdmpNodeInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ndmp node inline node inline links
func (o *NdmpNodeInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ndmp node inline node inline links based on the context it is used
func (o *NdmpNodeInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NdmpNodeInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NdmpNodeInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NdmpNodeInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NdmpNodeInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
